/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___VMARSHALER_H___
#define ___VMARSHALER_H___


#include	"v/v_types.h"
#include	"VObject.h"

// delete mode
#define DT_NONE		1
#define DT_ALL		2
#define DT_ONE		3

// action flags
#define AF_VALUE_M	0x03ffffff
#define AF_DONTCARE	0x03ffffff

#define AF_CLICK	0x08000000
#define AF_INITIALIZE	0x04000000

#define AF_VISIBLE_M	0xc0000000
#define AF_VISIBLE_OFF	0xc0000000
#define AF_VISIBLE_ON	0x40000000
#define AF_VISIBLE_DC	0x00000000

#define AF_ENABLE_M	0x30000000
#define AF_ENABLE_OFF	0x30000000
#define AF_ENABLE_ON	0x10000000
#define AF_ENABLE_DC	0x00000000



class VMarshaler
{
public:
	VMarshaler(int targets_nos,int m_values_nos);
	~VMarshaler();
	int set_target(int no,VObject * obj);
	void set_action(int a_no,int * values=0,int * m_value=0,int * a_value=0);
	int set_event_handler(int no,VObject * obj,V_CALLBACK(f),void * arg);

	int get_value(int no);

	int get_id();

	void __vm_value_handler(int target,int value,int click);
	void __vm_value_handler(VObject *,int value,int click);
	void __vm_destroy_handler(VObject *);
	void __set_id(int);
private:
	int		id;

	int		destroy_type;
	int		targets_nos;
	int *		target_values;
	int		m_values_nos;
	VObject **	obj_list;
	int		actions_nos;
	int **		action_tables;
	int *		m_values;
	VObject **	c_objects;
	void **		eh_args;
	V_CALLBACK_T	*event_handlers;

};

typedef struct vm_arg{
	int		id;
	int		value;
} VM_ARG;

#ifdef __cplusplus
extern "C" {
#endif


void init_VMarshaler(XLISP_ENV *env);
void init_marshaler();
VMarshaler * id2marshaler(int id);

#ifdef __cplusplus
}
#endif

#endif


