/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef __V_EDIT_TEXT_H__
#define __V_EDIT_TEXT_H__

#include "v/VObject.h"
#include "v/VEditable.h"

class VEditText : public VObject, public VEditable
{
  public:
	enum { object_type = VO_ETXT };
	virtual unsigned	get_type() const { return object_type; }
	
	enum VEditTextAttr {
		integer_only = 0x1
	};
	
	struct edit_text_set {
		short max_len;
		short min_len;
	};
	static VEditText*	create(const VObjectStatus *s, int flags, short max_len, short min_len = 20, VExError *err=0) {
		edit_text_set set = {max_len, min_len};
		return create(s, flags, &set, err);
	}
	static VEditText*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VEditText*>(
			create_tmp(internal_new, object_type, s, flags, err, arg));
	}
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;
	
	virtual void	descriptor_changed() {
		if ( sts.attr & integer_only )
			value_changed();
		VObject::descriptor_changed();
	}
	
	virtual void	focus();
	virtual bool	command_status(int type) const;
	virtual bool	obey_command(int type);

  protected:
	virtual ~VEditText();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);

	short		min_len;

  private:
	static VObject *internal_new(){
		return new VEditText();
	}
};

#endif
