/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_DRAW_H___
#define ___V_DRAW_H___

#include "v/VObject.h"

enum VMouseEventType {
	V_EV_MOUSE_DOWN,
	V_EV_MOUSE_UP,
	V_EV_MOUSE_MOVE,
	V_EV_MOUSE_ENTER,
	V_EV_MOUSE_LEAVE,
	
	V_EV_MOUSE_DOUBLE_CLICK
};

struct VMouseEvent
{
	VMouseEventType type;
	long	time;
	VPoint	point;
	short		button;	// pushed button number
	short		modifiers;	// key constants are defined in v_types.h
};

class VDraw : public VObject
{
  public:
	enum { object_type = VO_DRAW };
	virtual unsigned	get_type() const { return object_type; }
	
	enum VDrawAttr {
		mouse_move_wait		= 0x1,
		
		use_alpha			= 0x10
	};

	static VDraw*	create(const VObjectStatus *s, int flags, VExError *err=0) {
			return create(s, flags, 0, err);
	}
	static VDraw*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VDraw*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;
	
	virtual VImage*	draw_start(bool img_draw_start=true);	// lock object and return the image
	virtual void	draw_end(bool img_draw_end=true);		// unlock object
	virtual VError	set_image(VImage* img, VSize min_size = v_default_size);	// change image
	virtual VImage*	get_image() { return v_image_ref(img); }
	bool	get_draw_use_alpha() { return (sts.attr & use_alpha); }
	
	virtual void	set_mouse_event_handler(V_CALLBACK(handler), void *user_arg) {
		mouse_event_handler = handler;
		user_arg_mouse = user_arg;
	}
	virtual bool	mouse_event(VMouseEvent *event);	// called from OS on mouse event
	
	// call after mouse move event when mouse_move_wait to get new mouse move event
	virtual void	mouse_move_event_done();	
	
	virtual void	set_resize_event_handler(V_CALLBACK(handler), void *user_arg) {
		resize_event_handler = handler;
		this->user_arg_resize = user_arg;
	}
	virtual void	resize_event(VSize size) {	// called from OS on resize event
		if ( resize_event_handler )
			vq_insert_callback(this, resize_event_handler,
						user_arg_resize, &size, sizeof(size));
	}
	
  protected:
	virtual ~VDraw();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);
	
	VImage*	img;
	bool	img_locked;
	
	V_CALLBACK(mouse_event_handler);
	void	*user_arg_mouse;

	V_CALLBACK(resize_event_handler);
	void	*user_arg_resize;

  private:
	static VObject *internal_new(){
		return new VDraw();
	}
};


#endif
