/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_BUTTON_H___
#define ___V_BUTTON_H___

#include "v/VObject.h"

class VButton : public VObject
{
  public:
	enum { object_type = VO_VBTN };
	virtual unsigned	get_type() const { return object_type; }
		
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;
  protected:
  	virtual ~VButton();
	
	virtual void	destroy_do(VObject*);
};


class VPushButton : public VButton
{
  public:
	enum { object_type = VO_PUSH };
	virtual unsigned	get_type() const { return object_type; }
	
	enum VPushButtonAttr {
		default_button = 0x01,
		cancel_button = 0x02
	};
	
	static VPushButton*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VPushButton*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VPushButton*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
  protected:
	virtual ~VPushButton();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);

  private:
	static VObject *internal_new(){
		return new VPushButton();
	}
};



class VCheckBox : public VButton
{
  public:
	enum { object_type = VO_CHKB };
	virtual unsigned	get_type() const { return object_type; }
	
	static VCheckBox*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VCheckBox*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VCheckBox*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
  protected:
	virtual ~VCheckBox();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);

  private:
	static VObject *internal_new(){
		return new VCheckBox();
	}
};


class VRadioButton : public VButton
{
  public:
	enum { object_type = VO_RADB };
	virtual unsigned		get_type() const { return object_type; }
	
	static VRadioButton*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VRadioButton*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VRadioButton*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
	virtual VExError			get_status(VObjectStatus *, int flags) const;
	virtual VExError			set_status(const VObjectStatus *, int flags);
	
	virtual void			set_radio_group(VRadioButton *group);
	virtual VRadioGroupInfo	get_radio_group();
//	virtual VRadioButton*	get_current_radio();

  protected:
	virtual					~VRadioButton();
	
	virtual VExError		create_do(const VObjectStatus *, int flags,VObject * nmp, void * arg);
	virtual void			destroy_do(VObject*);
	
	VRadioGroupInfo	radio_group;
  
  private:
	static VObject *internal_new(){
		return new VRadioButton();
	}
};


class VPopupButton : public VButton
{
  public:
	enum { object_type = VO_POPB };
	virtual unsigned		get_type() const { return object_type; }
	
	static VPopupButton*	create(const VObjectStatus *s, int flags, VExError *err=0) {
		return create(s, flags, 0, err);
	}
	static VPopupButton*	create(const VObjectStatus *s, int flags,void *arg, VExError *err) {
		return static_cast<VPopupButton*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}
	
	virtual VExError			get_status(VObjectStatus *, int flags) const;
	virtual VExError			set_status(const VObjectStatus *, int flags);
	
	virtual VExError			set_list(int num, const L_CHAR **list,
										const LC_WRITING_STYLE **ws=0);
	virtual VExError			get_list(int *num, L_CHAR ***list, const LC_WRITING_STYLE ***ws=0);
	
  protected:
	virtual					~VPopupButton();
	
	virtual VExError		create_do(const VObjectStatus *, int flags,VObject * nmp, void * arg);
	virtual void			destroy_do(VObject*);
	
	int						list_num;
	L_CHAR **				list_lc;
	const LC_WRITING_STYLE **		list_ws;
	
	
  private:
	static VObject *internal_new(){
		return new VPopupButton();
	}
};

#endif
