/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___PDB64_INNER_H___
#define ___PDB64_INNER_H___

#include	"gbgraph.h"

#define NO_PITCH	0x100
#define DF_BUF	0x2000

typedef struct acc_header64 {
	U_INTEGER64	fofs;
} ACC_HEADER64;

typedef struct pn_header64 {
	unsigned int	type;
	unsigned int	size;
} PN_HEADER64;

typedef struct acc_pn_header64 {
	ACC_HEADER64	a;
	PN_HEADER64	h;
} ACC_PN_HEADER64;

#define PNT_TYPE_MASK		0x00ff
#define PNT_GROUP_MASK		0xff00
#define PNT_GET_GROUP(x)	(((x)&PNT_GROUP_MASK)>>8)

#define PNT_GROUP_MAX		3

#define PNT_POLYGON_GROUP	0x0000
#define PNT_FILE_HEADER		1
#define PNT_2D_DRAW_HEADER	2
#define PNT_LOD_LIST		3
#define PNT_TREE_NODE		4
#define PNT_POLYGON2D		5
#define PNT_POLY_POINT		6	
#define PNT_POLY_END		7
#define PNT_LNO_POLY_POINT	8
#define PNT_POLY_MAX		9

#define PNT_FAVT_GROUP		1
#define PNT_FAVT_ROOT		((PNT_FAVT_GROUP<<8)|1)
#define PNT_FAVT_NODE		((PNT_FAVT_GROUP<<8)|2)
#define PNT_FREELIST_HEADER	((PNT_FAVT_GROUP<<8)|3)
#define PNT_FREELIST_NODE	((PNT_FAVT_GROUP<<8)|4)
#define PNT_DTREE_DATA		((PNT_FAVT_GROUP<<8)|5)
#define PNT_FAVT_MAX		6

#define PNT_ASSOC_GROUP		2
#define PNT_ASSOC_HEADER	((PNT_ASSOC_GROUP<<8)|1)
#define PNT_ASSOC_DATA		((PNT_ASSOC_GROUP<<8)|2)

#define PNT_PMD_GROUP		3
#define PNT_PMD_HEADER		((PNT_PMD_GROUP<<8)|1)
#define PNT_PMD_NODE		((PNT_PMD_GROUP<<8)|2)
#define PNT_PMD_MD		((PNT_PMD_GROUP<<8)|3)
#define PNT_PMD_OFSLIST		((PNT_PMD_GROUP<<8)|4)

#define PNT_RT_CACHE_GROUP	4
#define PNT_RT_CACHE_HEADER	((PNT_RT_CACHE_GROUP<<8)|1)
#define PNT_RT_CACHE_DATA	((PNT_RT_CACHE_GROUP<<8)|2)
#define PNT_RT_CACHE_LIST	((PNT_RT_CACHE_GROUP<<8)|3)

#define PNT_RS_CACHE_GROUP	5
#define PNT_RS_CACHE_NULL	((PNT_RS_CACHE_GROUP<<8)|0)
#define PNT_RS_CACHE_HEADER	((PNT_RS_CACHE_GROUP<<8)|1)
#define PNT_RS_CACHE_DATA	((PNT_RS_CACHE_GROUP<<8)|2)
#define PNT_RS_RES_STATUS	((PNT_RS_CACHE_GROUP<<8)|3)
#define PNT_RS_COORDINATE	((PNT_RS_CACHE_GROUP<<8)|4)
#define PNT_RS_PIXEL_MAP_R64	((PNT_RS_CACHE_GROUP<<8)|5)
#define PNT_RS_DRAW_GB		((PNT_RS_CACHE_GROUP<<8)|6)
#define PNT_RS_RES_MAP		((PNT_RS_CACHE_GROUP<<8)|7)
#define PNT_RS_BIB_LIST		((PNT_RS_CACHE_GROUP<<8)|8)
#define PNT_RS_NOTE		((PNT_RS_CACHE_GROUP<<8)|9)
#define PNT_RS_CLIP		((PNT_RS_CACHE_GROUP<<8)|10)
#define PNT_RS_MAP		((PNT_RS_CACHE_GROUP<<8)|11)
#define PNT_RS_INFO_SCHEME	((PNT_RS_CACHE_GROUP<<8)|12)
#define PNT_RS_TRIANGLE		((PNT_RS_CACHE_GROUP<<8)|13)
#define PNT_RS_MAP_POINT_LIST	((PNT_RS_CACHE_GROUP<<8)|14)


/*******************************/


typedef struct pn_file_header64 {
	PN_HEADER64	h;
	int		type;	/* file type */
#define FT_2D_DRAW		1	/* draw file */
#define FT_2D_MAP		2	/* map file */
#define FT_2D_COORDINATE	3	/* coordinate system definition file */
#define FT_ADDRESS_LUMP		10	/* address lump system */
#define FT_RT_CACHE		11	/* routing cache */
	char		version[8];
#define VERSION		"0.4"
#define ENCODING_SIZE	8
	char		encoding[ENCODING_SIZE];
	unsigned int	linear;
	unsigned int	linear_length;
} PN_FILE_HEADER64;
#define PN_FILE_HEADER_S64	sizeof(PN_FILE_HEADER64)


/*******************************/
/*
	FILE AVT 
*/
/*******************************/

typedef struct pn_favt_root64 {
	PN_HEADER64	h;
	int		type;
#define FAST_DTREE	0x00000001
#define FAST_OTHER_TREE	0x00000000
#define FAST_DTREE_ROOT	0x00000001

#define FAT_DTREE_NODE	2

	U_INTEGER64	node;
} PN_FAVT_ROOT64;

#define PN_FAVT_ROOT_S64		sizeof(PN_FAVT_ROOT64)

typedef struct pn_favt_node64 {
	PN_HEADER64	h;
	U_INTEGER64	small;
	U_INTEGER64	large;
	int		level;
	/* user data is followed */
} PN_FAVT_NODE64;


#define PN_FVAT_NODE_S64		sizeof(PN_FAVT_NODE64)

typedef struct pn_freelist64 {
	PN_HEADER64	h;
	U_INTEGER64	next;
} PN_FREELIST64;


typedef struct pn_dtree_data64 {
	PN_HEADER64	h;
	unsigned int	data[1];
	/* two or more data are allowed */
} PN_DTREE_DATA64;

#define PN_DTREE_DATA_S64(x)	((int)(&((PN_DTREE_DATA64*)0)->data[x]))

/*******************************/
/*
	FAVT fundamental data structure
*/
/*******************************/


typedef struct floating_index64 {
	U_INTEGER64		fofs;
	REAL1			d;
} FLOATING_INDEX64;

typedef struct gb_time_index64 {
	U_INTEGER64		fofs;
	GB_TIME			d;
} GB_TIME_INDEX64;

typedef struct string_index64 {
	U_INTEGER64		fofs;
	L_CHAR			d[1];
} STRING_INDEX64;

#define STRING_IX_LENGTH(x,y)	((int)&(((STRING_INDEX*)0)->d[(x)+(y)+2]))
#define STRING_IX_LENGTH_1(x)	((int)&(((STRING_INDEX*)0)->d[(x)+1]))

typedef struct timeout_index64 {
	U_INTEGER64		fofs;
	unsigned int		timeout;
} TIMEOUT_INDEX64;


void favt_string_endian64(STRING_INDEX64 * ix,int len);
void favt_gb_time_endian64(GB_TIME_INDEX64 * ix,int len);
void favt_floating_endianv64(FLOATING_INDEX64 * ix,int len);
void favt_timeout_endian64(TIMEOUT_INDEX64 * ix,int len);

int favt_cmp_string_164(STRING_INDEX64 *,STRING_INDEX64 *);
int favt_cmp_string_264(STRING_INDEX64 *,STRING_INDEX64 *);


/*******************************/


#define CACHE_MAX	10000000

#include	"avt.h"

typedef struct fa_ring64 {
	struct fa_ring64 *	next;
	struct fa_ring64 *	prev;
} FA_RING64;

typedef struct fa_cache64 {
	struct fa_cache64 *	next;
	int			ref;
	char *			filename;
	AVT_NODE *		records;
} FA_CACHE64;

typedef struct fac_header64 {
	FA_RING64			r;
	FA_CACHE64 *		file;
	U_INTGEGER64		offset;
	PN_HEADER64		h;
} FAC_HEADER64;

#define SIZEOF_FAC64(size)	\
	(((int)(&((FAC_HEADER64*)0)->h))+(size))

typedef struct pdb_request64 {
	struct pdb_request64 *	next;
	U_INTEGER64		fofs;
	void *			option;
} PDB_REQUEST64;

typedef struct pdb64 {
	int		fid;
	int		flags;
#define PF_PDB_MASK	0x0000ffff
#define PF_CACHE	0x00000001
	unsigned int	fofs;
	PDB_REQUEST64 *	request;
	PDB_REQUEST64 *	next_request;
	FA_CACHE64 *	cache;
	char		data[DF_BUF];
	int		buf_ptr;
	int		buf_len;
	U_INTEGER64	seek_ptr;
	void *		freelist_work;
} PDB64;

PDB64 * open_pdb64(char * filename,int oflags,int mode,int flags);
void close_pdb64(PDB64 *);

void insert_request64(PDB64 *,unsigned int fofs,void * option);
int delete_request64(PDB64 * p,int (*func[])(),void*);

#define E_DR_NO_REQUEST	(-1)
#define E_DR_FILE_ACCESS (-2)
#define E_DR_SEGMENT_ACCESS (-3)
#define E_DR_UNSUPPORT_SEGMENT_TYPE (-4)

#ifndef OPEN_FILESPACE64
PDB64 * open_filespace64(char * filename,int oflags,int mode,int flags,...);
#endif
#define PF_USEFREELIST	0x80000000
unsigned int fs_raw_write64(PDB64 * p,void * d,int flags);
#define FSF_ONLYHEADER	0x00000001
#define FSF_RESERVE_SP	0x00000002


#endif

