/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___GBACRP_H___
#define ___GBACRP_H___

#include	"task.h"
#include	"queue.h"
#include 	"acrp.h"
#include	"gbgraph.h"

typedef struct mp_t {
	Q_HEADER		h;
	int			ttl;
	int			mp_ptr;
	MAP_PATH *		mp_tbl;
	L_CHAR *		start;
	L_CHAR *		target;
	int			mode;
	int			ret_mode;
	int			option;
	int *			target_cid;

	XL_SEXP *		remote;
	XL_FILE *		file;
	int			line;
	int			ret_sts;
	GB_TIME 		ver_time;

	D_SEXP *		d;
} MP_T;



typedef struct finish_list {
	struct finish_list *	next;
	char			list[ACRP_SUBID_NOS];
} FINISH_LIST;

typedef struct support_routing_check {
	int			ses;
	URL *			u;
	int			flags;
#define RSC_TARGET		0x00000001
#define RSC_RET_MODE		0x00000002
	int *			target;
	int			ret_mode;
	GB_TIME *		ver_time;
} SUPPORT_ROUTING_CHECK;


L_CHAR * regulation(MAP_PATH_TABLE *);
void
insert_acrp_rq(L_CHAR * filename);
L_CHAR *
delete_acrp_rq();
void trigger_around(int ses,L_CHAR * my_path,AROUND_LIST * al,int flags);


MP_T *
new_mp_t(int ttl,L_CHAR * start,L_CHAR * target);
void free_mp_t(MP_T * m);


void
reset_mp_entry(MAP_PATH *);
void
free_mp_entry(MAP_PATH*);
void
free_mp(MAP_PATH * mp,int len);
int support_routing_check(SUPPORT_ROUTING_CHECK * rsc);
int get_routing_err_code(XL_SEXP * er);

#endif

