/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"machine/v_x11.h"
#include	"lc_encode.h"

extern LC_DESCRIPTION_TABLE v_lcd_table[];

LC_DESCRIPTION_TABLE *
get_vfont_size(int * size,char * name)
{
LC_DESCRIPTION_TABLE * dt;
int len,len_dt;
char * p, * q;
char * data;
	len = strlen(name);

	for ( dt = &v_lcd_table[0] ; dt ; dt ++ ) {
		if ( dt->lcz == LCC_ERROR )
			return 0;
		len_dt = strlen(dt->name);
		if ( strcmp(dt->name,&name[len - len_dt]) == 0 )
			break;
	}
	for ( p = name ; *p && memcmp(p,"--",2) ; p ++ );
	if ( *p == 0 )
		return 0;
	p += 2;
	for ( ; *p && *p != '-' ; p ++ );
	if ( *p == 0 )
		return 0;
	p ++;
	for ( q = p ; *q && *q != '-' ; q ++ );
	data = d_alloc(q - p + 1);
	memcpy(data,p,q - p);
	data[q-p] = 0;
	*size = atoi(data);
	d_f_ree(data);
	return dt;
}






typedef struct _v_get_font_s {
	LC_FONT * 	f;
	LC_FONT_ENGINE * fe;
	int		ret;
} _V_GET_FONT_S;

int
_v_get_font(
	_V_GET_FONT_S * v)
{

int cnt_max;
char ** fonts;
int size;
VFONT * vf;
char * fontname;
int j,i,cnt,len;
VDISPLAY * d;
LC_FONT_SIZE_LIST sl;
LC_DESCRIPTION_TABLE * dt;
LC_FONT * f;

printf("_v_get_font in\n");
	f = v->f;
	d = (VDISPLAY*)v->fe->work;
	fontname = ln_copy_str(&ascii_cm,f->fontname);
	cnt_max = 10;
	for ( ; ; ) {
		fonts = XListFonts(d->d,fontname,cnt_max,&cnt);
		if ( fonts == 0 )
			goto err1;
		if ( cnt_max > cnt )
			break;
		XFreeFontNames(fonts);
		cnt_max += 10;
	}
	vf = d_alloc(sizeof(*vf));
	vf->fontname = fontname;
	vf->vlist = d_alloc(sizeof(VFONT_LIST)*cnt);
	vf->vlist_len = 0;

	len = 0;
	for ( i = 0 ; i < cnt ; i ++ ) {
		dt = get_vfont_size(&size,fonts[i]);
		if ( size == 0 )
			continue;
		for ( j = 0 ; j < len ; j ++ )
			if ( vf->vlist[j].size == size )
				break;
		if ( j != len )
			continue;
		vf->vlist[len].fs = XLoadQueryFont(d->d,fonts[i]);
		if ( dt ) {
			if ( f->mask[0] != LCZM_ALL && f->mask[0] != 0  ) {
				if ( dt->mask & (~f->mask[0]) )
					goto next;
				if ( (dt->lcz & dt->mask)
					!= (f->lcz[0] & dt->mask) )
					goto next;
			}
			f->mask[0] = dt->mask;
			f->lcz[0] = dt->lcz;
		next:
			f->mask[1] = LCZM_ALL;
			f->lcz[1] = LCC_ERROR;
		}
		vf->vlist[len].name = copy_str(fonts[i]);
		vf->vlist[len].size = size;
		len ++;
	}

	if ( len == 0 )
		goto err2;

	vf->vlist_len = len;

	for ( i = 0 ; i < len ; i ++ ) {

		sl.size = vf->vlist[i].size;
		sl.from = f->lcz[0] | (vf->vlist[i].fs->min_byte1<<8) |
				vf->vlist[i].fs->min_char_or_byte2;
		sl.to = (f->lcz[0] | (vf->vlist[i].fs->max_byte1<<8) |
				vf->vlist[i].fs->max_char_or_byte2);
		_insert_lc_font_size_list(f,&sl);
	}

	insert_font_work(f,v->fe,vf);

	v->ret = 0;
printf("_v_get_font out\n");
	return 0;
err2:
	d_f_ree(vf->vlist);
	d_f_ree(vf);
err1:
	d_f_ree(fontname);
	v->ret = -1;
printf("_v_get_font out\n");
	return 0;
}


int 
v_get_font(LC_FONT * f,LC_FONT_ENGINE * fe)
{
_V_GET_FONT_S v;
	v.f = f;
	v.fe = fe;

	ms_do((int (*)(void *))_v_get_font,(void*)&v,1,"v_get_font");
	
	return v.ret;
}



VFONT_LIST *
v_get_vfont_list(VFONT * vf,int size,int method)
{
VFONT_LIST * ret;
int i;
	ret = 0;
	switch ( method ) {
	case FST_JUST:
		for ( i = 0 ; i < vf->vlist_len ; i ++ )
			if ( vf->vlist[i].size == size ) {
				ret = &vf->vlist[i];
				break;
			}
		break;
	case FST_NEARLY:
		for ( i = 0 ; i < vf->vlist_len ; i ++ ) {
			if ( ret == 0 ||
				IABS(ret->size - size)
				> IABS(vf->vlist[i].size - size) )
				ret = &vf->vlist[i];
		}
		break;
	case FST_SMALL:
		for ( i = 0 ; i < vf->vlist_len ; i ++ ) {
			if ( vf->vlist[i].size > size )
				continue;
			if ( ret == 0 ||
				size - ret->size >
					size - vf->vlist[i].size )
				ret = &vf->vlist[i];
		}
		break;
	case FST_LARGE:
		for ( i = 0 ; i < vf->vlist_len ; i ++ ) {
			if ( vf->vlist[i].size < size )
				continue;
			if ( ret == 0 ||
				ret->size - size <
					vf->vlist[i].size - size )
				ret = &vf->vlist[i];
		}
		break;
	default:
		er_panic("v_get_vfont_list");
	}
	return ret;
}


