//
// 
//	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
// 
//	This program is free software; you can redistribute it 
//	and/or modify it under the terms of the GLOBALBASE 
//	Library General Public License (G-LGPL) as published by 
//
//	http://www.globalbase.org/
// 
//	This program is distributed in the hope that it will be 
//	useful, but WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A 
//	PARTICULAR PURPOSE.
//
//

extern "C" {

#include	<stdlib.h>
#include	<stdio.h>
#include	"machine/v_types.h"
#include	"memory_debug.h"
#include	"param_gbview.h"
#include	"CLEMWindow.h"
void er_panic(char*);

void
v_after_handling(VOBJECT * obj);


void
v_draw_text_one_font_8(
	VRECT * r,
	VOBJECT * obj,
	VPOINT * st,
	char * str,
	int len,
	short id,
	short size)
{
RGBColor fcolor, bcolor;
FontInfo fontinfo;
Rect rect;

	obj->header.win->w->BeginDraw();
	TextFont(id);
	TextSize(size/10);
	GetFontInfo(&fontinfo);
	SetRect(&rect, st->x, st->y-fontinfo.ascent, 
			st->x+TextWidth(str, 0, len), st->y+fontinfo.descent+TEXT_LEADING);
	if ( ! (obj->vtext.in.background & C_NULL) ) {
		GB2RGB(obj->vtext.in.background, bcolor);
		RGBBackColor(&bcolor);
		EraseRect(&rect);
	}
	GB2RGB(obj->vtext.in.color, fcolor);
	RGBForeColor(&fcolor);
	MoveTo(st->x, st->y);
	DrawText(str, 0, len);
	obj->header.win->w->EndDraw(&rect);

	r->tl.y = rect.top;
	r->tl.x = rect.left;
	r->br.y = rect.bottom;
	r->br.x = rect.right;
	st->x += (rect.right-rect.left);
}

char *
convert_8(LCF_SET * str,int len)
{
char * ret;
int i;
	ret = (char*)d_alloc(len);
	for ( i = 0; i < len ; i ++ )
		ret[i] = str[i].ch;
	return ret;
}

char *
convert_7(LCF_SET * str,int len)
{
char * ret;
int i;
	ret = (char*)d_alloc(len);
	for ( i = 0; i < len ; i ++ )
		ret[i] = str[i].ch&0x7f;
	return ret;
}

char *
convert_16(LCF_SET * str,int *len)
{
char * ret;
int i, j = 0;
	ret = (char*)d_alloc(*len*2);
	for ( i = 0 ; i < *len ; i ++ ) {
		if ( (str[i].ch>>8)&0xff )
			ret[j++] = (str[i].ch>>8)&0xff;
		ret[j++] = str[i].ch&0xff;
	}
	*len = j;
	return ret;
}


void
v_draw_text_one_font(
	VRECT * r,
	VOBJECT * obj,
	VPOINT * st,
	LCF_SET * str,
	int len,
	VFONT * vf,
	int size,
	L_CHAR mask)
{
char * str8;
short id = vf->id;
	if ( size < 0 )
		size = vf->default_size;

	if ( mask == LCZM_7b_TYPE ) {
		str8 = convert_7(str,len);
		v_draw_text_one_font_8(r,obj,st,str8,len,id,size);
		d_f_ree(str8);
	}
	else if ( mask == LCZM_1B_TYPE ) {
		str8 = convert_8(str,len);
		v_draw_text_one_font_8(r,obj,st,str8,len,id,size);
		d_f_ree(str8);
	}
	else if ( mask == LCZM_2B_TYPE ) {
		str8 = convert_16(str,&len);
		v_draw_text_one_font_8(r,obj,st,str8,len,id,size);
		d_f_ree(str8);
	}
	else
		er_panic("v_draw_text_one_font >=3 byte char is not supported");
	
}


void
v_after_handling(VOBJECT * obj)
{
}


} // extern "C"