/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

// ===========================================================================
//	CLEMWindow.h
// ===========================================================================

#ifndef ___CLEMWINDOW_H___
#define ___CLEMWINDOW_H___

#include <PP_Prefix.h>
#include "machine/v_types.h"

#define DEF_WINDOW_ID	128

class CLEMWindow : public LWindow
{
public:
	enum {class_ID = 'Clem' };
				CLEMWindow(LStream *);
	virtual		~CLEMWindow();
	virtual void	DrawSelf(void);
	virtual void	ClickSelf(const SMouseDownEvent &inMouseDown);
	virtual void	EventMouseUp(const EventRecord& inMacEvent);
	virtual void	ResizeFrameBy(SInt16 inWidthDelta, SInt16 inHeightDelta, Boolean inRefresh);
	void 			GetCLEMWindowAttributes(struct vwindow_attributes * attr);
	void			SetCloseHandler(Boolean(*closeH)()) { mCloseHandler = closeH; }
	void			ClearContent(void);

	virtual void	AttemptClose();

	void			BeginDraw();
	void			EndDraw(Rect * rect);
	void			EndDraw(RgnHandle rgn = nil);
	VWINDOW *		vwin;
private:
	Point			lastPoint;
	Boolean			(*mCloseHandler)();
};

Window openDefaultWindow(int x, int y, int w, int h, VWINDOW *vwin, Boolean(*closeHandler)());
#endif