/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"xllock.h"

XL_SEXP * xl_Unlock();


void
init_Unlock(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Unlock"),
		get_func_prim(xl_Unlock,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_Unlock(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * name;
int er;
	name = get_el(s,1);
	if ( get_type(name) != XLT_STRING )
		goto type_missmatch;
	er = xl_unlock(name->string.data);
	if ( er < 0 ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNDEF_NAME,
			l_string(std_cm,"Unlock"),
			List(n_get_string("undef lock obj"),
				get_integer(er,0),-1));
	}
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Unlock"),
		0);
}


