/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"
#include	"xlerror.h"

XL_SEXP *
gb_if(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * cond;
	cond = eval(env,get_el(s,1));
	switch ( get_type(cond) ) {
	case XLT_ERROR:
		return cond;
	case XLT_INTEGER:
		if ( cond->integer.data )
			goto _true;
		else	goto _false;
	case XLT_FLOAT:
		if ( cond->floating.data != 0 )
			goto _true;
		else	goto _false;
	default:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"if"),
			list(	n_get_string(
				"type missmatch in condition"),
				0));
	}
_true:
	return eval(env,get_el(s,2));
_false:
	return eval(env,get_el(s,3));
}
