/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	"task.h"
#include	"lock_level.h"
#include	"log.h"
#include	"memory_routine.h"
#include	"xl.h"
#include	"stream.h"

int gc_log_trace(AVT_NODE * a,int * cnt);
void gc_log(MEM_STATISTICS * ms);
void gc_tick_notin_tick();


#define GC_TICK_INTERVAL	10
#define GC_THRESHOLD_UP		1000000
#define GC_THRESHOLD_DOWN	 500000

#define GC_MS_INTERVAL		120

extern int malloc_count;
int free_count;
SEM gc_task_lock;

int gc_tick_interval;


int ms_time;

int
gc_log_trace(AVT_NODE * a,int * cnt)
{
MS_NODE * n;
	n = a->data;
	log_printf(LOG_DEBUG,LOG_LAYER_XL,0,"::GC_MEM_%i %s:%i / size=%i\n",
		(*cnt)++,
		n->file,
		n->line,
		n->total_size);
	return 0;
}

void
gc_log(MEM_STATISTICS * ms)
{
int i;
	i = 0;
	avt_trace_from_large(ms->root,gc_log_trace,&i);
	log_printf(LOG_DEBUG,LOG_LAYER_XL,0,"====");
}

void
gc_tick()
{
int ret;
int res;
unsigned int st_time,interval;
MEM_STATISTICS ms;
MEM_STATISTICS * msp;
int now;

log_printf(LOG_DEBUG,LOG_LAYER_XL,0,"GC START\n");

	now = get_xltime();
	if ( now - ms_time > GC_MS_INTERVAL ) {
		msp = &ms;
		ms_time = now;
	}
	else	msp = 0;

	res = s_check_resource();

	st_time = get_xltime();

	lock_task(gc_task_lock);

	gc_lock();

	lock_mem();

	GC_POSITION;

	gc();

	GC_POSITION;

	sp_gc();

	GC_POSITION;

	free_count = ret = _mem_gc(msp);

	after_gc();

	unlock_mem();

	gc_unlock();

	if ( msp ) {
		gc_log(&ms);
		free_mem_statistics(&ms);
	}

	unlock_task(gc_task_lock,"gc_task");

	interval = get_xltime() - st_time;

	if ( free_count > GC_THRESHOLD_UP || res < 0 ) {
		gc_tick_interval = gc_tick_interval/2;
		if ( gc_tick_interval < 1)
			gc_tick_interval = 1;
		if ( gc_tick_interval < 5*interval )
			gc_tick_interval = 5*interval;
		change_tick(gc_tick_interval);
	}
	else if ( free_count < GC_THRESHOLD_DOWN ) {
		gc_tick_interval ++;
		if ( gc_tick_interval > GC_TICK_INTERVAL )
			gc_tick_interval = GC_TICK_INTERVAL;
		if ( gc_tick_interval < 5*interval )
			gc_tick_interval = 5*interval;
		change_tick(gc_tick_interval);
	}
	else if ( gc_tick_interval < 5*interval ) {
		gc_tick_interval = 5*interval;
		change_tick(gc_tick_interval);
	}


	log_printf(LOG_DEBUG,LOG_LAYER_XL,0,"GC END %i %i\n",ret,malloc_count);
}

void
gc_tick_notin_tick()
{
int ret;
int res;
unsigned int st_time,interval;

	res = s_check_resource();

	st_time = get_xltime();

	lock_task(gc_task_lock);

	gc_lock();

	lock_mem();
/*
printf("GC START\n");
*/
	gc();
	sp_gc();
	free_count = ret = _mem_gc(0);
	after_gc();

	unlock_mem();

	gc_unlock();

	unlock_task(gc_task_lock,"gc_task");
/*
printf("END %i %i\n",ret,malloc_count);
*/
	interval = get_xltime() - st_time;

	if ( free_count > GC_THRESHOLD_UP || res < 0 ) {
		gc_tick_interval = gc_tick_interval/2;
		if ( gc_tick_interval < 1)
			gc_tick_interval = 1;
		if ( gc_tick_interval < 5*interval )
			gc_tick_interval = 5*interval;
	}
	else if ( free_count < GC_THRESHOLD_DOWN ) {
		gc_tick_interval ++;
		if ( gc_tick_interval > GC_TICK_INTERVAL )
			gc_tick_interval = GC_TICK_INTERVAL;
		if ( gc_tick_interval < 5*interval )
			gc_tick_interval = 5*interval;
	}
	else if ( gc_tick_interval < 5*interval ) {
		gc_tick_interval = 5*interval;
	}
}

void
gc_enable()
{

	gc_lock();

	lock_mem();
/*
printf("GC START\n");
*/
	gc();
	sp_gc();
	_mem_gc(0);
	after_gc();
/*
printf("END %i %i\n",ret,malloc_count);
*/
	unlock_mem();

	gc_unlock();
}

void
init_gc_task()
{
	gc_task_lock = new_lock(LL_GC_TASK);
	gc_tick_interval = GC_TICK_INTERVAL;
	new_tick((void(*)())gc_tick,GC_TICK_INTERVAL,0);
}
