/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"xl.h"
#include	"text_render.h"
#include	"tr_lang.h"
#include	"memory_debug.h"
#include	"ex_utils.h"
#include	"xlerror.h"

XLISP_ENV * language_env;


XL_SEXP *
ex_language(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a,
	XL_SYM_FIELD * sf)
{
L_CHAR * lang;
L_CHAR * seed;
XL_SEXP * _lang,* _seed;
TR_LANG * target;
TR_LANG * new_target;
L_CHAR * dir;
int _dir;
XLISP_ENV * new_e;
void * w;
	lang = get_sf_attribute(sf,l_string(std_cm,"lang"));
	seed = get_sf_attribute(sf,l_string(std_cm,"seed"));
	if ( lang == 0 || seed == 0 )
		goto parameter;
	_lang = eval(language_env,get_symbol(lang));
	if ( get_type(_lang) != XLT_ERROR )
		goto ex_obj;
	_seed = eval(language_env,get_symbol(seed));
	switch ( get_type(_seed) ) {
	case XLT_ERROR:
		return _seed;
	case XLT_ENV:
		break;
	default:
		goto parameter;
	}
	if ( _seed->env.data->e.work == 0 )
		er_panic("ex_language");
	target = _seed->env.data->e.work;
	new_target = d_alloc(sizeof(*new_target));
	*new_target = *target;
	new_target->work = 0;
	strcpy(new_target->lang,n_string(std_cm,lang));

	tr_system_lock();
	_tr_insert_lang(new_target);

	w = (*target->get_setup)(target,0);
	(*new_target->setup_lang)(new_target,TRT_INIT_BIN,w);

	tr_system_unlock();

	(*new_target->free_work)(w);

	dir = get_sf_attribute(sf,l_string(std_cm,"dir"));
	if ( dir ) {
		_dir = get_writing_dir(dir);
		if ( _dir < 0 )
			goto parameter;
		new_target->dir_flags = _dir;
	}
	dir = get_sf_attribute(sf,l_string(std_cm,"subdir"));
	if ( dir ) {
		_dir = get_writing_dir(dir);
		if ( _dir < 0 )
			goto parameter;
		new_target->sub_dir_flags = _dir;
	}
	new_e = new_env(_seed->env.data);
	new_e->e.work = new_target;
	set_env(language_env,lang,
		get_func_prim(ex_body,FO_NORMAL,new_e,1,-1));
	return 0;
parameter:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"language"),
		0);
ex_obj:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_DUP_DEFINITION,
		l_string(std_cm,"language"),
		n_get_string("already existing the language"));
/*
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"space"),
		n_get_string("perhaps you exec outside of en env."));
*/
}


void
init_ex_language(XLISP_ENV * env)
{
	language_env = new_env(env);
	set_env(env,l_string(std_cm,"language"),
		get_func_prim(ex_language,FO_APPLICATIVE,0,1,1));
	init_ex_en(env);
	init_ex_ja(env);
}








