/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xl.h"
#include	"xlerror.h"

XL_SEXP * xl_SetPrefixMode();

void
init_SetPrefixMode(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetPrefixMode"),
		get_func_prim(xl_SetPrefixMode,FO_APPLICATIVE,0,4,-1));
}

XL_SEXP *
xl_SetPrefixMode(XLISP_ENV * env,XL_SEXP * s,
		 XLISP_ENV * a_env,XL_SYM_FIELD * sf)
{
XL_SEXP * pref;
XL_SEXP * a;
XL_SEXP * m;
int flags;
XL_SEXP * cmd,* c;
	flags = XLGF_XLDOC_ONLY|XLGF_LOCK_OFF;
	pref = get_el(s,1);
	if ( get_type(pref) != XLT_STRING )
		goto type_missmatch;
	a = get_el(s,2);
	if ( get_type(a) != XLT_STRING )
		goto type_missmatch;
	m = get_el(s,3);
	if ( get_type(m) != XLT_STRING )
		goto type_missmatch;
	for ( ; sf ; sf = sf->next ) {
		if ( l_strcmp(sf->name,l_string(std_cm,"xlsys")) == 0 ) {
			if ( l_strcmp(sf->data,
					l_string(std_cm,
					"precedence")) == 0 ) {
				flags &= ~XLGFM_XLDIR;
				flags |= XLGF_XLSYS_PRECEDENCE;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,
					"only")) == 0 ) {
				flags &= ~XLGFM_XLDIR;
				flags |= XLGF_XLSYS_ONLY;
			}
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"xldocs"))
						 == 0 ) {
			if ( l_strcmp(sf->data,
					l_string(std_cm,
					"precedence")) == 0 ) {
				flags &= ~XLGFM_XLDIR;
				flags |= XLGF_XLDOC_PRECEDENCE;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,
					"only")) == 0 ) {
				flags &= ~XLGFM_XLDIR;
				flags |= XLGF_XLDOC_ONLY;
			}
		}
		else if ( l_strcmp(sf->name,l_string(std_cm,"lock")) == 0 ) {
			if ( l_strcmp(sf->data,
					l_string(std_cm,
					"full")) == 0 ) {
				flags &= ~XLGFM_LOCK;
				flags |= XLGF_FULL_PATH;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,
					"url")) == 0 ) {
				flags &= ~XLGFM_LOCK;
				flags |= XLGF_URL_PATH;
			}
			else if ( l_strcmp(sf->data,
					l_string(std_cm,
					"off")) == 0 ) {
				flags &= ~XLGFM_LOCK;
				flags |= XLGF_LOCK_OFF;
			}
		}
	}
	cmd = cdr(cdr(cdr(cdr(s))));
	for ( c = cmd ; get_type(c) ; c = cdr(c) ) {
		if ( get_type(car(c)) != XLT_STRING )
			goto type_missmatch;
	}
	insert_getfile(
		pref->string.data,
		a->string.data,
		m->string.data,
		flags,
		cmd);
	return pref;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"SetPrefixMode"),
		n_get_string("type missmatch"));
}
