/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_SetChar();

void
init_SetChar(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"SetChar"),
		get_func_prim(xl_SetChar,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_SetChar(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * cd;
L_CHAR str[2];
	cd = get_el(s,1);
	if ( get_type(cd) != XLT_INTEGER ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"SetChar"),
			list(	n_get_string("index error in SetChar argument"),
				0));
	}
	str[0] = cd->integer.data;
	str[1] = 0;
	return get_string(str);
}
