/**********************************************************************
 
	Copyright (C) 2004 
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_Mv();

void
init_Mv(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Mv"),
		get_func_prim(xl_Mv, FO_APPLICATIVE, 0, 3, 3));
}

XL_SEXP *
xl_Mv(XLISP_ENV * env, XL_SEXP * s, XLISP_ENV * arg_env, XL_SYM_FIELD * sf)
{
XL_SEXP * from;
XL_SEXP * to;
U_STAT stat_buf;
char *from_;
char *to_;
int flags;
char *name;

	flags = 0;
	from = get_el(s,1);
	to = get_el(s,2);
	
	if(get_type(from) != XLT_STRING){
		goto type_missmatch;
	}
	if(get_type(to) != XLT_STRING){
		goto type_missmatch;
	}
	
	from_ = n_string(std_cm, from->string.data);
	name = strrchr(from_, '/');
	if(name == 0){
		name = from_;
	}
	from_ = change_delim_str(from_);
	to_ = n_string(std_cm, to->string.data);
	u_stat(to_, &stat_buf);
	
	if(stat_buf.us_mode & S_IFDIR){
		char buff[512];
		buff[511] = 0;
		strncpy(buff, n_string(std_cm, to->string.data), 511);
		if(strlen(buff) + strlen(name) >= sizeof(buff)){
			d_f_ree(from_);
			goto too_long_filename;
		}
		if(buff[strlen(buff)-1] != '/'){ 
			strcat(buff, "/");
		}
		strcat(buff, name);
		to_ = change_delim_str(buff);
	}
	else{
		to_ = change_delim_str(to_);
		u_unlink(to_);
	}

	if(rename(from_,to_) != 0){
		char *err;
		switch(errno){
		case EACCES:
			err = "EACCES";
			break;
		case ENOENT:
			err = "ENOENT";
			break;
		case EINVAL:
			err = "EINVAL";
			break;
		}
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_OPEN_FILE,
			l_string(std_cm,"rename"),
			List(n_get_string(from_),
				n_get_string(to_),
				n_get_string(err),
				-1));
	}
	d_f_ree(from_);
	d_f_ree(to_);
	return 0;

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Rm"),
		List(n_get_string("filename"),
			n_get_string("is type missmatch"),
			-1));
too_long_filename:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_INV_FORMAT,
		l_string(std_cm,"Rm"),
		List(get_string(from->string.data),
			get_string(to->string.data),
			n_get_string("too long filename"),
			-1));
}

