/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"utils.h"
#include	"xl.h"
#include	"memory_debug.h"

XL_SEXP * xl_Leaf();

void
init_Leaf(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Leaf"),
		get_func_prim(xl_Leaf,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_Leaf(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * path;
XL_SEXP * skip;
L_CHAR * buf;
XL_SEXP * ret;
int _skip;
L_CHAR * p;
	path = get_el(s,2);
	switch ( get_type(path) ) {
	case XLT_ERROR:
		return path;
	case XLT_STRING:
		buf = ll_copy_str(path->string.data);
		break;
	default:
		goto type_missmatch;
	}
	skip = get_el(s,1);
	switch ( get_type(skip) ) {
	case XLT_ERROR:
		return skip;
	case XLT_INTEGER:
		_skip = skip->integer.data;
		break;
	case XLT_FLOAT:
		_skip = skip->floating.data;
		break;
	default:
		goto type_missmatch;
	}
	p = buf;
	if ( *p == '/' )
		p ++;
	for ( ; _skip ; _skip -- ) {
		if ( *p == 0 )
			break;
		for ( ; *p && *p != '/' ; p ++ );
		if ( *p == 0 )
			break;
		p ++;
	}
	ret = get_string(p);
	d_f_ree(buf);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Leaf"),
		0);
}
