/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <stdlib.h>

#include "v/VEditText.h"
#include "v/vobj_utils.h"

extern "C" {
#include "xl.h"


XL_SEXP *
vobj_VEditText(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);

XL_SEXP *
vobj_VEditText(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
	VEditText *obj;
	XL_SEXP * _ref;
	VObjectStatus _sts;
	VEditText::edit_text_set set = {32767, 10};
	VObject * go;

	_ref = _vobj_GetStatus(&go,env,arg,a,sf,0);
	if ( get_type(_ref) != 0 )
		return _ref;

	L_CHAR *attr;
	if ( ( attr = get_sf_attribute(sf, l_string(std_cm, "max_len")) ) )
		set.max_len = atoi(n_string(std_cm,attr));
	if ( ( attr = get_sf_attribute(sf, l_string(std_cm, "min_len")) ) )
		set.min_len = atoi(n_string(std_cm,attr));

	_ref = get_refered_object<VEditText>
			(&obj,env,arg,sf,VO_ETXT,"VEditText",&_sts,0,&set);

	switch ( get_type(_ref) ) {
	case XLT_INTEGER:
		return vobj_get_id_list(_ref->integer.data,0,sf,0);
	case XLT_ERROR:
		return _ref;
	}
	return 0;
}

void
init_VEditText(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VEditText"),
		get_func_prim((XL_SEXP*(*)())vobj_VEditText,FO_NORMAL,0,1,1));
}


} // extern "C"
