/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VAlignView.h"
#include "v/vobj_utils.h"

extern "C" {
#include "xl.h"
#include "xlerror.h"

XL_SEXP * vobj_VAlignView(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);
XL_SEXP * vobj_ReorderChild(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);

XL_SEXP *
vobj_VAlignView(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
	XL_SEXP * _ref;
	VAlignView *obj;
	VObjectStatus sts;
	XL_SEXP *cmd = get_el(arg, 0);

	if ( get_type(cmd) == XLT_SYMBOL && 
			l_strcmp(cmd->symbol.data, l_string(std_cm, "VHAlignView")) == 0 )
		_ref = get_refered_object<VHAlignView>
				((VHAlignView**)&obj,env,arg,sf,VO_HGRV,"VHAlignView",&sts,0,0);
	else	_ref = get_refered_object<VVAlignView>
				((VVAlignView**)&obj,env,arg,sf,VO_VGRV,"VVAlignView",&sts,0,0);
	if ( get_type(_ref) != XLT_INTEGER )
		return _ref;

	obj->get_status(&sts, VSF_ID);
	XL_SEXP *ret = vobj_eval_child(sts.id, env, arg);
	if ( get_type(ret) == XLT_ERROR )
		return ret;
	switch ( get_type(_ref) ) {
	case XLT_INTEGER:
		return vobj_get_id_list(_ref->integer.data,ret,sf,0);
	case XLT_ERROR:
		return _ref;
	}
	return vobj_get_id_list(sts.id, ret, sf,0);
}

XL_SEXP *
vobj_ReorderChild(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
	XL_SEXP *target = get_el(arg, 1);
	XL_SEXP *child = get_el(arg, 2);
	XL_SEXP *order = get_el(arg, 3);
	if ( get_type(target) != XLT_INTEGER || get_type(child) != XLT_INTEGER ||
				get_type(order) != XLT_INTEGER )
		return get_error(
			arg->h.file,
			arg->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"ReorderChild"),
			n_get_string("type missmatch"));
	VAlignView *obj1 = dynamic_cast<VAlignView*>(
		VObject::get_object_by_id(target->integer.data));
	VObject *obj2 = VObject::get_object_by_id(child->integer.data);
	if ( obj1 == 0 || obj2 == 0 )
		return vobj_get_error(initial_VExError(V_ER_NOT_FOUND,0,0), arg);
	
	VExError err = obj1->reorder_child(obj2, order->integer.data);
	return vobj_get_error(err, arg);
}

void
init_VAlignView(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VHAlignView"),
		get_func_prim((XL_SEXP*(*)())vobj_VAlignView,FO_NORMAL,0,1,-1));
	set_env(env,l_string(std_cm,"VVAlignView"),
		get_func_prim((XL_SEXP*(*)())vobj_VAlignView,FO_NORMAL,0,1,-1));

	set_env(env,l_string(std_cm,"ReorderChild"),
		get_func_prim((XL_SEXP*(*)())vobj_ReorderChild,FO_APPLICATIVE,0,4,4));
}


} // extern "C"
