/**********************************************************************
 
	Copyright (C) 2003-2005
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <openssl/rsa.h>

#include "ossl.h"


#ifdef GBSSL_TEST
#define d_alloc malloc
#define d_f_ree free
#define gbrsa_test_main main
#else
#include "memory_debug.h"
#endif

#define RSA_PKCS1_PADDING_SIZE 11

/*
extern struct rsa_st;
typedef struct rsa_st RSA;

extern RSA *d2i_RSAPrivateKey(RSA **a, const unsigned char **in, long len);
extern int i2d_RSAPrivateKey(const RSA *a, unsigned char **out);

extern RSA *d2i_RSAPublicKey(RSA **a, const unsigned char **in, long len);
extern int i2d_RSAPublicKey(const RSA *a, unsigned char **out);

extern int RSA_private_decrypt(int flen, const unsigned char *from, unsigned char *to,
	     RSA *rsa, int padding);
extern int RSA_public_encrypt(int flen, const unsigned char *from, unsigned char *to,
	     RSA *rsa, int padding);
extern int RSA_size(const RSA *r);
extern void RSA_free(RSA *r);
#define RSA_PKCS1_PADDING	1
*/

int
oSSL_decode(
oSSLdata * private_key,
oSSLdata * decode,
oSSLdata * org)
{
	RSA *rsa;
	unsigned char *in_ptr;
	unsigned char *out_ptr;
	unsigned char *ptr;
	int max_rsa_decode_size;
	int decode_size;
	int decoded_size;
	int left_data_size;
	int max_decoded_len;

	decode->data = 0;
	decode->len = 0;
	
	/* load public key RSA from private_key->data */
	ptr = (unsigned char*)private_key->data;
	rsa = d2i_RSAPrivateKey(NULL, &ptr, (long)private_key->len);
	if(rsa == NULL){
		goto err;
	}
	max_rsa_decode_size = RSA_size(rsa);
	
	in_ptr = (unsigned char*)org->data;
	left_data_size = org->len;
	
	max_decoded_len = max_rsa_decode_size*((org->len+max_rsa_decode_size-1)/max_rsa_decode_size);
	decode->len = 0;
	decode->data = (char *)d_alloc(max_decoded_len);
	out_ptr = (unsigned char*)decode->data;
	while(left_data_size>0){
		if(max_rsa_decode_size > left_data_size){
			decode_size = left_data_size;
		}
		else{
			decode_size = max_rsa_decode_size;
		}
		decoded_size = RSA_private_decrypt(decode_size, in_ptr, (unsigned char*)&decode->data[decode->len], rsa, RSA_PKCS1_PADDING);
		if(decoded_size == -1){
			goto err;
		}
		decode->len += decoded_size;
		in_ptr += decode_size;
		left_data_size -= decode_size;
	}
	
	RSA_free(rsa);
	return 0;
err:
	d_f_ree(decode->data);
	RSA_free(rsa);
	return -1;
}

int
oSSL_encode(
oSSLdata * public_key,
oSSLdata * encode,
oSSLdata * org)
{
	RSA *rsa;
	unsigned char *in_ptr;
	unsigned char *out_ptr;
	unsigned char *ptr;
	int max_rsa_encode_size;
	int encode_size;
	int encoded_size;
	int left_data_size;

	encode->data = 0;
	encode->len = 0;
	
	/* load public key RSA from public_key->data */
	ptr = (unsigned char*)public_key->data;
	rsa = d2i_RSAPublicKey(NULL, &ptr, (long)public_key->len);
	if(rsa == NULL){
		goto err;
	}

	max_rsa_encode_size = RSA_size(rsa)-RSA_PKCS1_PADDING_SIZE;
	
	in_ptr = (unsigned char*)org->data;
	left_data_size = org->len;
	
	encode->len = RSA_size(rsa)*((org->len+max_rsa_encode_size-1)/max_rsa_encode_size);
	encode->data = (char *)d_alloc(encode->len);
	out_ptr = (unsigned char*)encode->data;
	while(left_data_size>0){
		if(max_rsa_encode_size > left_data_size){
			encode_size = left_data_size;
		}
		else{
			encode_size = max_rsa_encode_size;
		}
		encoded_size = RSA_public_encrypt(encode_size, in_ptr, out_ptr, rsa, RSA_PKCS1_PADDING);
		if(encoded_size == -1){
			goto err;
		}
		in_ptr += encode_size;
		out_ptr += encoded_size;
		left_data_size -= encode_size;
	}
	
	RSA_free(rsa);
	return 0;
err:
	d_f_ree(encode->data);
	RSA_free(rsa);
	return -1;
}


int
oSSL_genkey(oSSLdata * public_key, oSSLdata * private_key, int size)
{
	RSA *rsa;
	unsigned char* out_ptr;
	int public_key_length;
	int private_key_length;


	rsa = RSA_generate_key(size/* key bit size */, RSA_F4, NULL, NULL);
	if(rsa == NULL){
		return -1;
	}
	
	public_key_length = i2d_RSAPublicKey(rsa, NULL);
	
	public_key->len = public_key_length;
	public_key->data = (char*)d_alloc(public_key_length);
	out_ptr = (unsigned char*)public_key->data;
	i2d_RSAPublicKey(rsa, &out_ptr);
	
	private_key_length = i2d_RSAPrivateKey(rsa, NULL);
	private_key->len = private_key_length;
	private_key->data =  (char*)d_alloc(private_key_length);
	out_ptr = (unsigned char*)private_key->data;
	i2d_RSAPrivateKey(rsa, &out_ptr);
	
	RSA_free(rsa);
	
	return 0;
}

void
oSSL_free_data(oSSLdata * d)
{
	if(d->len){
		d_f_ree(d->data);
		d->len = 0;
	}
}


#ifdef GBSSL_TEST
int gbrsa_test_main(int argc, char* argv[])
{
#define KEY_BIT_LENGTH 1024
	/* open ssl test code */
	unsigned char test_plain_text[] = "aiueo kakikukeko sasisuseso tachituteto aaaaaaaaa b";
	unsigned char decrypted_buff[256];
	int crypted_data_size;
	RSA *rsa;
	int encodable_length;
	unsigned char *crypted;
	int crypted_len;
	int decrypted_len;

	encodable_length = 64-11;

	rsa = RSA_generate_key(KEY_BIT_LENGTH, RSA_F4, NULL, NULL);
	
	crypted_data_size = RSA_size(rsa);
	crypted = (unsigned char*)malloc(crypted_data_size);

	crypted_len = RSA_private_encrypt(
			sizeof(test_plain_text), 
			(unsigned char*)test_plain_text, 
			crypted,
			rsa,
			RSA_PKCS1_PADDING);
	
	decrypted_len = RSA_public_decrypt(
		crypted_len,
		crypted,
		decrypted_buff,
		rsa,
		RSA_PKCS1_PADDING);
	
	if(memcmp(test_plain_text, decrypted_buff, sizeof(test_plain_text)) == 0){
		printf("ok\n");
	}
	else{
		printf("err\n");
	}

	{
		RSA *r;
		int decrypted_len2;
		r = RSA_new();
		r->n = rsa->n;
		r->e = rsa->e;
		
		decrypted_len2 = RSA_public_decrypt(
			crypted_len,
			crypted,
			decrypted_buff,
			r,
			RSA_PKCS1_PADDING);
		
		r->n=NULL;
		r->e=NULL;
		RSA_free(r);
	}
	RSA_free(rsa);




	/* gbs RSA test code */
	{
		oSSLdata public_key;
		oSSLdata private_key;
		oSSLdata encoded;
		oSSLdata org;
		oSSLdata decoded;
		
		if(oSSL_genkey(&public_key, &private_key, 1024) == -1){
			printf("err 1");
		}

		org.len = strlen("hogehogefoobar abcdefghijklmn")+1;
		org.data = d_alloc(org.len);
		strcpy(org.data, "hogehogefoobar abcdefghijklmn");
		
		if(oSSL_encode(&public_key, &encoded, &org) == -1){
			printf("err 2");
		}
		oSSL_free_data(&org);
		oSSL_free_data(&public_key);
		
		if(oSSL_decode(&private_key, &decoded, &encoded) == -1){
			printf("err 3");
		}
		oSSL_free_data(&encoded);
		oSSL_free_data(&private_key);
		
		printf("test decoded data = %s", decoded.data);
		oSSL_free_data(&decoded);
		
	}
	return 0;
}
#endif
