/**********************************************************************
 
	Copyright (C) 2003 Shuichiro Suzuki<shu@zeta.co.jp>
                       Tomohito Nakajima<nakajima@zeta.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#define SHAPE_FILE_CODE 9994

/* definition of ShapeTypes */
#define NULL_SHAPE 0
#define POINT 1
#define POLYLINE 3
#define POLYGON 5
#define MULTIPOINT 8
#define POINTZ 11
#define POLYLINEZ 13 
#define POLYGONZ 15
#define MULTIPOINTZ 18
#define POINTM 21
#define POLYLINEM 23
#define POLYGONM 25
#define MULTIPOINTM 28
#define MULTIPATCH 31

/* definition of ext */
#define MAIN_EXT ".shp"
#define INDEX_EXT ".shx"
#define SVG_EXT ".svg"

/*
//===================================//
//	struct for MainFile
//===================================//
*/
#define SIZEOF_HEADER 100
/* FileHeader */
struct Header{
	INT FileCode;/* 9994 BigEndian */
	INT NoUse[5];/* BigEndian */
	INT FileLength;/* unit is BYTE. The unit of this value saved in the file is WORD(16bit). BigEndian. */
	INT Version;/* 1000 */
	INT ShapeType;
	DOUBLE Xmin;
	DOUBLE Ymin;
	DOUBLE Xmax;
	DOUBLE Ymax;
	DOUBLE Zmin;
	DOUBLE Zmax;
	DOUBLE Mmin;
	DOUBLE Mmax;
};

/* RecordHeader */
#define SIZEOF_RECORDHEADER 8
struct RecordHeader{
	INT RecordNo;/* BigEndian */
	INT ContentLength;/* unit is BYTE. The unit of this value saved in the file is WORD(16bit). BigEndian. */
};

/*
//======================================//
//		struct for IndexFile
//======================================//
*/
/* IndexRecord */
#define SIZEOF_INDEXRECORD 8
struct IndexRecord{
	INT Offset;/* unit is BYTE. The unit of this value saved in the file is WORD(16bit). BigEndian. */
	INT ContentLength;/* unit is BYTE. The unit of this value saved in the file is WORD(16bit). BigEndian. */
};
