/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPF_VARIABLE_LENGTH_INDEX_H___
#define VPF_VARIABLE_LENGTH_INDEX_H___

#include "vpf_types.h"
#include "vpf_container.h"

typedef struct VariableLengthIndexHeader{
	LONG number_of_entries;
	LONG vpf_table_header_size;
}VARIABLE_LENGTH_INDEX_HEADER;

typedef struct VariableLengthIndexRecord{
	LONG offset;
	LONG size;
}VARIABLE_LENGTH_INDEX_RECORD;
VARIABLE_LENGTH_INDEX_RECORD *variable_length_index_record_new();
void variable_index_index_record_delete(VARIABLE_LENGTH_INDEX_RECORD *r);

typedef struct VariableLengthIndexFile{
	VARIABLE_LENGTH_INDEX_HEADER header;
	VPF_LIST *records;
}VARIABLE_LENGTH_INDEX_FILE;

VARIABLE_LENGTH_INDEX_FILE *variable_length_index_file_new();
void variable_length_index_file_delete(VARIABLE_LENGTH_INDEX_FILE *i);
int variable_length_index_file_load(VARIABLE_LENGTH_INDEX_FILE *ret, const char *filename);

#endif

