/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_face.h"



VPF_RECORD_READER_BEGIN(
	face_record_read, 
	VPF_FACE_RECORD)
	VPF_READ_FIELD(id)
	VPF_READ_FIELD_MULTI(aft_id)
	VPF_READ_FIELD(ring_ptr)
VPF_RECORD_READER_END()


void face_record_delete(VPF_FACE_RECORD *face)
{
	if(face==NULL)
		return;
	free(face);
}

VPF_FACE_RECORD *vpf_table_get_face(VPF_TABLE *face_table, LONG id)
{
	VPF_LIST_ITEM *it;
	VPF_FACE_RECORD *r;
	for(it = face_table->records->head; it; it=it->next){
		r = (VPF_FACE_RECORD *)it->data;
		if(r->id == id)
			return r;
	}
	return NULL;

}

