/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef VPF_EDGE_H____
#define VPF_EDGE_H____

#include "vpf_types.h"
#include "vpf_container.h"
#include "vpf_table.h"
#include "vpf_variable_length_index.h"

typedef struct {
	LONG id;
	LONG lft_id[VPF_MAX_FEATURE_COL];
	LONG start_node;
	LONG end_node;
	TRIPLET_ID right_face;
	TRIPLET_ID left_face;
	TRIPLET_ID right_edge;
	TRIPLET_ID left_edge;
	VPF_LIST *coordinates;
}VPF_EDGE_RECORD;

BOOL edge_record_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);

void edge_record_delete(VPF_EDGE_RECORD *edge);
void get_max_rect_from_edge(VPF_RECT *ret, const VPF_EDGE_RECORD *edge);
void get_max_rect_form_edges(VPF_RECT *ret, VPF_LIST *records);
VPF_EDGE_RECORD *vpf_table_get_edge(VPF_TABLE *edge_table, LONG id);
BOOL vpf_edge_is_boundary(const VPF_EDGE_RECORD *edge);
#endif

