/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"long_char.h"
#include	"lc_encode.h"
#include	"text_render.h"
#include	"tr_lang.h"

TR_ERROR
make_ctl_render(TR_SEQUENCE * ,TR_CHAR_INFO *);

TR_LANG ctl_render = {
	"ctl",
	VSD_ALL,0,
	0,
	0,
	0,
	make_ctl_render,
	0
};


TR_ERROR
make_rc_render(TR_SEQUENCE * sq,TR_CHAR_INFO * ci)
{
TR_LANG_LINE * ll;
int dir;
TR_ERROR e;
TR_LL_CTL ctl;
TR_ELEMENT * el;
	ll = _tr_prev_lang_line(ci->lang_line);
	if ( ll == 0 )
		dir = ci->box_line->attr.default_dir;
	else	dir = ll->dir;
	ci->lang_line->dir = dir;

	ctl.h.cmd = LLC_RETURN_CODE;
	ctl.rc.ch = '\n';
	ctl.rc.dir = ci->box_line->attr.default_dir;

	(*sq->box_op->start_lang_line_op)(sq,ci);
	e = _tr_new_element(&el,sq,ci->lang_line);
	switch ( e.code ) {
	case TRE_OK:
		(*sq->box_op->lang_line_ctl)(sq,ci,&ctl);
		el->cr = ctl.rc.dir;
		ci->lang_line->end = tr_ptr_next(ci->p);
		break;
	case TRE_INSERT_CHAR:
		ci->lang_line->end = ci->p;
		e.code = TRE_OK;
		e.subcode = TRE_OK_NEW_LINE;
		break;
	default:
		er_panic("tr_ctl");
	}
	e = _tr_stop_lang_line_op(e,sq,ci);
	if ( e.code == TRE_OK )
		e.subcode = TRE_OK_NEW_LINE;
	return e;
}

TR_ERROR
make_ctl_render(TR_SEQUENCE * sq,TR_CHAR_INFO * ci)
{
L_CHAR ch;
TR_ERROR e;
	e.code = TRE_OK;
	e.subcode = TRE_OK_NEW_LINE;
	ch = ci->p.buf->element_buf[ci->p.ptr].ch;
	switch ( ch ) {
	case '\r':
	case '\n':
		return make_rc_render(sq,ci);
	default:
		er_panic("make_ctl_render");
		return e;
	}
}


