/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_debug.h"
#include	"window.h"
#include	<stdio.h>

void
print_str(L_CHAR * s)
{
	for ( ; *s ; s ++ )
		printf("%x,",(int)*s);
	printf("\n");
}


void
compose_pic(LC_STRING_PIC * p,LC_STRING_PIC * pp)
{
LC_STRING_PIC ppp;
int w,h,ww,hh;
int x,y,i;
int y_ofs,x_ofs;
	ppp.width = p->width + pp->width;
	ppp.dir = p->dir;
	ppp.r.tl.x = p->r.tl.x;
	if ( p->r.tl.y < pp->r.tl.y )
		ppp.r.tl.y = p->r.tl.y;
	else	ppp.r.tl.y = pp->r.tl.y;
	ppp.r.br.x = p->width + pp->r.br.x;
	if ( p->r.br.y < pp->r.br.y )
		ppp.r.br.y = pp->r.br.y;
	else	ppp.r.br.y = p->r.br.y;
	w = ppp.r.br.x - ppp.r.tl.x;
	h = ppp.r.br.y - ppp.r.tl.y;
	ppp.pic = d_alloc(w*h);
	for ( i = 0 ; i < w*h ; i ++ )
		ppp.pic[i] = 255;
	ww = p->r.br.x - p->r.tl.x;
	hh = p->r.br.y - p->r.tl.y;
	y_ofs = p->r.tl.y - ppp.r.tl.y;
	i = 0;
	for ( y = y_ofs ; y < hh+y_ofs ; y ++ )
		for ( x = 0 ; x < ww ; x ++ )
			ppp.pic[x + y*w] = p->pic[i++];
	x_ofs = -ppp.r.tl.x+p->width+pp->r.tl.x;
	y_ofs = pp->r.tl.y - ppp.r.tl.y;
	ww = pp->r.br.x - pp->r.tl.x;
	hh = pp->r.br.y - pp->r.tl.y;
	i = 0;
	for ( y = y_ofs ; y < hh+y_ofs ; y ++ )
		for ( x = x_ofs ; x < ww+x_ofs ; x ++ ){
			if ( pp->pic[i] != 255 )
				ppp.pic[x + y*w] = pp->pic[i];
			i ++;
		}
	d_f_ree(p->pic);
	d_f_ree(pp->pic);
	*p = ppp;
}


void
get_string_pic(
	LC_STRING_PIC * sp,
	LC_WRITING_STYLE * ws,
	L_CHAR * str,
	int	size,
	int 	dir)
{
LCF_SET * s;
int p,q;
LC_FONT * wf;
LC_STRING_PIC spp;
int f;
int f_size;
LC_WS_COND wsc;
int i;
	wsc.cond = WSC_PIC_REQUIRED;
	s = ws_convert(ws,&wsc,size,str,l_strlen(str),
		CBF_SRC_PLANE|CBF_DST_PLANE);
	if ( s == 0 )
		er_panic("get_string_pic");
	f = 0;
	for ( p = 0 ; s[p].ch ; ) {
		wf = s[p].font;
		f_size = s[p].size;
		for ( q = p ; s[q].font == wf && s[q].size == f_size ; q ++ );
		for ( i = 0 ; i < wf->fw_len ; i ++ )
			if ( wf->fw_list[i].fe->type->fe_get_pic )
				break;
		if ( i == wf->fw_len )
			er_panic("get_string_pic");
		(*wf->fw_list[i].fe->type->fe_get_pic)
			(&spp,dir,&s[p],q - p);
		if ( f == 0 ) {
			*sp = spp;
			f = 1;
		}
		else {
			compose_pic(sp,&spp);
		}
		p = q;
	}
	d_f_ree(s);
}

void
get_string_pic_font(
	LC_STRING_PIC * sp,
	LC_FONT * font,
	int size,
	L_CHAR * str,
	int len,
	int dir)
{
int i;
LCF_SET * set;
	for ( i = 0 ; i < font->fw_len ; i ++ )
		if ( font->fw_list[i].fe->type->fe_get_pic )
			break;
	if ( i == font->fw_len )
		er_panic("get_string_pic");
	set = str2lcf(str,len,font,size);
	(*font->fw_list[i].fe->type->fe_get_pic)
		(sp,dir,set,len);
	d_f_ree(set);
}


void
pic_rotate_90(LC_STRING_PIC * dest,LC_STRING_PIC * src)
{
int w,h;
int x,y;
unsigned char * s, * d;
/*
	dest->r.tl.y = src->r.tl.x;
	dest->r.tl.x = - src->r.tl.y;
	dest->r.br.y = src->r.br.x;
	dest->r.br.x = - src->r.br.y;
*/
	dest->r.tl.x = - src->r.br.y;
	dest->r.tl.y = src->r.tl.x;
	dest->r.br.x = - src->r.tl.y;
	dest->r.br.y = src->r.br.x;

	w = src->r.br.x - src->r.tl.x;
	h = src->r.br.y - src->r.tl.y;
	dest->pic = d_alloc(w*h);
	s = src->pic;
	for ( y = 0 ; y < h ; y ++ ) {
		d = &dest->pic[h - y -1];
		for ( x = 0 ; x < w ; x ++ ) {
			*d = *s ++;
			d += h;
		}
	}
}


