/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___GBLISP_H___
#define ___GBLISP_H___
/*
#define LEX_DEBUG
#define PARSE_DEBUG
*/

#include	"stream.h"
#include	"xllisp_types.h"

/* errors */

#ifndef E_OK
#define E_OK		0
#define E_SYS		(-1)
#endif

#define E_GBOPEN	(-0x101)

/* print_sexp flags */
#define PF_RAW_DISABLE	0x00000010
#define PF_RAW_CLEAR	0x00000020
#define PF_MULTI_ROOT	0x00000040
#define PF_INDENT	0x00000080
#define PF_LISP_MODE	0x00000100
#define PF_TEXT		0x00000200

#define PFM_FORMAT	0x00000003
#define PF_LISP		0x00000000
#define PF_XML		0x00000001
#define PF_HTML		0x00000002

int curret_check(XL_SEXP *);

unsigned int hash_key(L_CHAR*);

void print_sexp(STREAM *,XL_SEXP * ,int);
int e_print_sexp(STREAM *,int *,XL_SEXP * ,int);

XL_SEXP * get_sexp(XL_FILE*,int);
XL_SEXP * get_sexp_inh(XL_FILE*,int,XL_SEXP*);
XL_SEXP * realize_sexp(XL_SEXP * s);
XL_SEXP * car(XL_SEXP*);
XL_SEXP * cdr(XL_SEXP*);
int get_type(XL_SEXP*);
int get_type_sexp(XL_SEXP*);
XL_SEXP * list(XL_SEXP *,...);
XL_SEXP * List(XL_SEXP *,...);
XL_SEXP * append(XL_SEXP *,XL_SEXP *);
XL_SEXP * cons(XL_SEXP *,XL_SEXP *);
XL_SEXP * cons_inh_2(XL_SEXP *,XL_SEXP *);
XL_SEXP * gb_let(XLISP_ENV *,XL_SEXP *);
XL_SEXP * get_symbol(L_CHAR*);
void set_attribute(XL_SEXP *,L_CHAR *,L_CHAR *);
XL_SEXP * replace_attribute(XL_SEXP *,L_CHAR * ,L_CHAR * );
XL_SEXP * n_get_symbol(char *);
XL_SEXP * get_string(L_CHAR*);
XL_SEXP * n_get_string(char*);
XL_SEXP * get_integer(int,L_CHAR*);
XL_SEXP * n_get_integer(int,char*);
XL_SEXP * get_floating(double,L_CHAR*);
XL_SEXP * n_get_floating(double,char*);
XL_SEXP * get_raw(char * data,int size);
XL_SEXP * get_raw_set_data(char * data,int size);
XL_SEXP * get_error(
	XL_FILE *	f,
	int		line,
	int		er_code,
	L_CHAR *	func,
	XL_SEXP * 	s);
XL_SEXP * get_error_line(XL_SEXP * ,int);
XL_SEXP * get_func_prim(XL_SEXP * (*)(),int,XLISP_ENV*,int,int);
XL_SEXP * get_func_prim_sp(XL_SEXP * (*)(),int,XLISP_ENV*,XLISP_ENV*,
			   int,int);
XL_SEXP * get_ptr(void *,void (*)());
XL_SEXP * get_env(XLISP_ENV *);
XL_SEXP * init_parse(STREAM *,L_CHAR*,L_CHAR*);
XL_SEXP * init_delay_func(DELAY_FUNC *);
int cmp_sexp(XL_SEXP * a,XL_SEXP * b);
XL_SEXP * get_el(XL_SEXP *,int);
XL_SEXP * get_el_by_symbol(XL_SEXP *,L_CHAR *, ...);
XL_SEXP * get_el_by_symbol_cnt(L_CHAR * tag,int cnt,XL_SEXP * s);
XL_SEXP * get_el_c(XL_SEXP *,L_CHAR *,L_CHAR *);
int list_length(XL_SEXP *);
XLISP_ENV * new_env(XLISP_ENV *);
XLISP_ENV * new_env_pair(XLISP_ENV *,XLISP_ENV *);
void init_gblisp();
XL_SEXP * eval(XLISP_ENV * env,XL_SEXP * sym);
XL_SEXP *
binary(BINARY_TABLE bt[XLT_MAX][XLT_MAX],XLISP_ENV *,XL_SEXP *,XL_SEXP *);
ELEMENT *
search_env(XLISP_ENV * env,L_CHAR * sym);
void set_env(XLISP_ENV * env,L_CHAR * sym,XL_SEXP *);
void del_env(XLISP_ENV * env,L_CHAR * sym);
void set_default_env(XLISP_ENV * env,XL_SEXP *);
void del_default_env(XLISP_ENV * env);
int set_sym(XLISP_ENV *,L_CHAR * sym,XL_SEXP *);
UNIT_ENV * get_uenv(XLISP_ENV *);
void set_uenv(XLISP_ENV *,UNIT_ENV *);

XL_SEXP * gb_list(XLISP_ENV * , XL_SEXP * );
XL_SEXP * gb_div(XLISP_ENV *, XL_SEXP *);
XL_SEXP * gb_define(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_while(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_equ(XLISP_ENV*,XL_SEXP *);
XL_SEXP * gb_leq(XLISP_ENV*,XL_SEXP *);
XL_SEXP * gb_add(XLISP_ENV*,XL_SEXP *);
XL_SEXP * gb_mul(XLISP_ENV*,XL_SEXP *);
XL_SEXP * gb_sub(XLISP_ENV*,XL_SEXP *);
XL_SEXP * gb_set(XLISP_ENV*,XL_SEXP *,XLISP_ENV*,XL_SYM_FIELD*);
XL_SEXP * inherit(XL_SEXP *,XL_SEXP *);
XL_SEXP * set_line_fix(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_quote(XLISP_ENV*,XL_SEXP *);
XL_SEXP * gb_quote_trace(XLISP_ENV*,XL_SEXP*,L_CHAR*);
XL_SEXP * gb_quote_long(XLISP_ENV*,XL_SEXP *,XLISP_ENV *,XL_SYM_FIELD*);
XL_SEXP * gb_save(XLISP_ENV * ,XL_SEXP* );
XL_SEXP * gb_load(XLISP_ENV * ,XL_SEXP *);
XL_SEXP * gb_quote(XLISP_ENV * ,XL_SEXP *);
XL_SEXP * gb_shell(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_wait(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_lambda(XLISP_ENV * ,XL_SEXP *);
XL_SEXP * gb_if(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_append(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_cons(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_car(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_cdr(XLISP_ENV *,XL_SEXP *);
XL_SEXP * gb_null_func();
XL_SEXP * search_error(XL_SEXP *);
void set_env_work(XLISP_ENV *,void*);
void * get_env_work(XLISP_ENV *);
L_CHAR * get_symbol_field(XL_SEXP *,L_CHAR *);
L_CHAR * get_sf_attribute(XL_SYM_FIELD * sf,L_CHAR * name);
XL_SEXP * get_env_symbol(XLISP_ENV *,L_CHAR *);
void
set_parseflags(XL_FILE * f,int set_flags,int res_flags);
void set_file_line(XL_FILE * ,int);

XLISP_ENV * get_root_env(XLISP_ENV *);
XL_SEXP * list_error(XL_SEXP *);
XL_SYM_FIELD *
set_sym_field(XL_SYM_FIELD *,L_CHAR *,L_CHAR *);

int gblisp_error(XL_FILE * f,int line,int er_code,
		 char * type,XL_SEXP * s);
int gblisp_relay_error(XL_FILE * to,int line,XL_FILE * from);

CODE_METHOD * get_cm(XL_SEXP *);

void set_close_func(XL_FILE * f,void (*func)(),void * work);

void setcr_lock();
void setcr_unlock();

extern L_CHAR * gblisp_site;
extern int (*error_handler)();
extern XLISP_ENV *	gblisp_top_env0;
extern XLISP_ENV *	gblisp_top_env1;
extern XL_FILE * std_file;
extern XL_SEXP * (*break_check)();

void gc_push(void * s,void (*gc)(),char * msg);
void gc_pop(void * s,void (*gc)());

STREAM * get_sexp_stream(XL_SEXP *);
L_CHAR * get_base_unit(XL_SEXP *);


/* conversion prototype */

XL_SEXP * conv_if(XL_SEXP * s);
XL_SEXP * conv_is(XL_SEXP * s);
XL_SEXP * conv_fs(XL_SEXP * s);
XL_SEXP * not_equal(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * div_ii(XLISP_ENV *,XL_SEXP * s1,XL_SEXP * s2);
XL_SEXP * div_ff(XLISP_ENV *,XL_SEXP * s1,XL_SEXP * s2);
XL_SEXP * rem_ii(XLISP_ENV *,XL_SEXP * s1,XL_SEXP * s2);
XL_SEXP * rem_ff(XLISP_ENV *,XL_SEXP * s1,XL_SEXP * s2);

XL_SEXP * equ_str(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * equ_sym(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * equ_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * equ_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * equ_func(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * equ_pair(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * leq_str(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * leq_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * leq_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * leq_pair(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * leq_null(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * leq_sym(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * leq_diff(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * lt_str(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * lt_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * lt_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * lt_pair(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * lt_null(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * lt_diff(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * lt_sym(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * add_str(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * add_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * add_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * mul_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * mul_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * sub_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * sub_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * and_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * or_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * xor_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * And_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * And_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * And_int_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * And_float_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * Or_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * Or_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * Or_int_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * Or_float_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

XL_SEXP * Xor_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * Xor_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * Xor_int_float(XLISP_ENV *,XL_SEXP *,XL_SEXP *);
XL_SEXP * Xor_float_int(XLISP_ENV *,XL_SEXP *,XL_SEXP *);

int
equ_conv_int(XLISP_ENV * env,int * i1,int * i2,XL_SEXP * s1,XL_SEXP * s2);
int
equ_conv_float(XLISP_ENV * env,
	       double * i1,double * i2,XL_SEXP * s1,XL_SEXP * s2);

int check_delay(XL_SEXP * s,int key);
int get_delay_info(STREAM **,DELAY_FUNC ** buf,XL_SEXP * s);

XL_SEXP *
xl_GetElement(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * aa,XL_SYM_FIELD * sff);
L_CHAR *
eval_carret(XL_SEXP ** retp,XLISP_ENV * env,L_CHAR * str,XL_SEXP * arg);

void gc_gblisp();
void gc_gc_stack();
void sp_gc_gblisp();
void sp_gc_load();
int gbb_equ(XL_SEXP * s1,XL_SEXP * s2);
void over_write_sexp(XL_SEXP * d,XL_SEXP * from);

int _eval_symbol(XL_SEXP ** ret,XLISP_ENV * env,L_CHAR * sym);
XL_SEXP * eval_symbol(XLISP_ENV * env,XL_SEXP * s);
int _eval_default_symbol(XL_SEXP ** ret,XLISP_ENV * env);
XL_SEXP * get_sym_field(XL_SYM_FIELD ** sfp,XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * eval_pair(XLISP_ENV * env,XL_SEXP * s);

void freev_header(XL_SEXP_HEADER * h);
void free_header(XL_SEXP * s);
void free_pair(XL_SEXP * s);
void free_symbol(XL_SEXP * s);
void free_string(XL_SEXP * s);
void free_integer(XL_SEXP * s);
void free_float(XL_SEXP * s);
void free_func(XL_SEXP * s);
void free_ptr(XL_SEXP * s);
void free_raw(XL_SEXP * s);
void free_sexp(XL_SEXP * s);


void gc_gb_sexp(XL_SEXP * p);
void gc_gb_delay(XL_DELAY * p);
void gc_gblisp_env(XLISP_ENV * p);
void gc_unit_alias(UNIT_ALIAS * p);
void gc_system_unit(SYSTEM_UNIT * p);
void gc_unit_env(UNIT_ENV * p);
void gc_entity(ENTITY * p);
void gc_entity_stack(ENTITY_STACK * p);
void gcv_gb_header(XL_SEXP_HEADER * p);
void gc_gb_header(XL_SEXP_HEADER * p);
void gc_gb_pair(XL_PAIR * p);
void gc_gb_sym_field(XL_SYM_FIELD * p);
void gc_gb_symbol(XL_SYMBOL * p);
void gc_gb_string(XL_STRING * p);
void gc_gb_integer(XL_INTEGER * p);
void gc_gb_float(XL_FLOAT * p);
void gc_gb_func(XL_FUNC * p);
void gc_gb_ptr(XL_PTR * p);
void gc_gb_raw(XL_RAW * p);
void gc_gb_error(XL_ERROR * p);
void gc_gb_gblisp_env(XL_XLISP_ENV * p);
void gc_element(ELEMENT * p);
void gc_gb_env(XL_ENV * p);
void gc_gb_env_pair(XL_ENV_PAIR * p);

UNIT_ENV * _get_uenv(XLISP_ENV * env);

XL_SEXP * gb_rem(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * search_error(XL_SEXP * s);
void search_inh(XL_FILE ** f,int * line,XL_SEXP * s);
void _set_inh(XL_FILE * f,int line,XL_SEXP * s);

void init__q_xml(XLISP_ENV * env);
void _q_xml_encoding(XL_SEXP * s,L_CHAR * code);
void set_encoding_st(STREAM * st,L_CHAR * code);
void init_sh_arg(int _argc,char ** _argv);
void init_Arg(XLISP_ENV * env);
void init_AtachAttribute(XLISP_ENV * env);
void init_Break(XLISP_ENV * env);
void init_Cast(XLISP_ENV * env);
XL_SEXP * cast_integer2string(XL_SEXP * s,L_CHAR * opt);
XL_SEXP * cast_symbol2string(XL_SEXP * s);
XL_SEXP * cast_floating2string(XL_SEXP * s);
L_CHAR *  discard_space(L_CHAR * str,int zero_ignore);
XL_SEXP * cast_string2integer(XL_SEXP * s,L_CHAR * opt);
XL_SEXP * cast_string2floating(XL_SEXP * s,L_CHAR * opt);
XL_SEXP * cast_string2string(XL_SEXP * from,L_CHAR * opt);
void init_Categorize(XLISP_ENV * env);
void init_Chdir(XLISP_ENV * env);
void init_CloseInterpreter(XLISP_ENV * env);
void init_CloseSession(XLISP_ENV * env);
void init_ComposePath(XLISP_ENV * env);
void init_ComposeURL(XLISP_ENV * env);
void init_Continue(XLISP_ENV * env);
void init_ConvertUnit(XLISP_ENV * env);
void init_CurrentEnvironment(XLISP_ENV * env);
void init_CutOut(XLISP_ENV * env);
void init_CutString(XLISP_ENV * env);
void init_DecodeURLString(XLISP_ENV * env);
char _dec_set_q(char ch);
char dec_set_q(L_CHAR * p);
void init_Define(XLISP_ENV * env);
XL_SEXP * _xl_Define(XLISP_ENV * env,XL_SEXP * s,XL_SYM_FIELD * sf);
XL_SEXP * _xl_Define_Normal(XLISP_ENV * env,XL_SEXP * s,XL_SYM_FIELD * sf);
XL_SEXP * _xl_Define_Applicative(XLISP_ENV * env,XL_SEXP * s,XL_SYM_FIELD * sf);
void init_DefineDefault(XLISP_ENV * env);
XL_SEXP * _xl_DefineDefault(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_DefineDefault_Normal(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_DefineDefault_Applicative(XLISP_ENV * env,XL_SEXP * s);
void init_DeleteDefaultDefine(XLISP_ENV * env);
void init_DeleteDefine(XLISP_ENV * env);
void init_Directory(XLISP_ENV * env);
void init_DivideString(XLISP_ENV * env);
XL_SEXP * xl_div_str_str(XL_SEXP * d,L_CHAR * term);
XL_SEXP * xl_div_str_pair(XL_SEXP * d,L_CHAR * term);
XL_SEXP * xl_div_str(XL_SEXP * d,L_CHAR * term);
void init_EA(XLISP_ENV * env);
void init_Remote(XLISP_ENV * env);
void init_List(XLISP_ENV * env);
void init_Eval(XLISP_ENV * env);
void init_EE(XLISP_ENV * env);
XL_SEXP * get_rmt(L_CHAR * str);
int check_rmt(XL_SEXP * rmt,XL_SEXP * sym);
XL_SEXP * _EE(XLISP_ENV * env,XL_SEXP * cmd,XL_SEXP * target,XL_SEXP * rmt);
XL_SEXP * EE_normal(XLISP_ENV * env,XL_SEXP * cmd,XL_SEXP * target,XL_SEXP * rmt);
XL_SEXP * EE_list(XLISP_ENV * env,XL_SEXP * cmd,XL_SEXP * target,XL_SEXP * rmt);
void init_ErrHandler(XLISP_ENV * env);
void init_Exit(XLISP_ENV * env);
void init_FindFile(XLISP_ENV * env);
int get_condition(L_CHAR * cond);
void init_For(XLISP_ENV * env);
XL_SEXP * _xl_For(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_For_cnt(XLISP_ENV * env,XL_SEXP * s,L_CHAR * dec);
void init_GetAttribute(XLISP_ENV * env);
void init_GetChar(XLISP_ENV * env);
void init_GetCPUStatus(XLISP_ENV * env);
void init_GetElement(XLISP_ENV * env);
void init_GetIid(XLISP_ENV * env);
void init_GetLocalHostIP(XLISP_ENV * env);
void init_GetLocalHostName(XLISP_ENV * env);
void init_GetParentEnvironment(XLISP_ENV * env);
void init_GetPrefixMode(XLISP_ENV * env);
void init_GetProperCode(XLISP_ENV * env);
void init_GetProxy(XLISP_ENV * env);
void init_GetSize(XLISP_ENV * env);
int get_size(XL_SEXP * g);
void init_GetSymbolCore(XLISP_ENV * env);
void init_GetTag(XLISP_ENV * env);
void init_GetType(XLISP_ENV * env);
void init_GetUnit(XLISP_ENV * env);
void init_GetURL(XLISP_ENV * env);
void init_GetVariable(XLISP_ENV * env);
void init_GetVersion(XLISP_ENV * env);
void init_GetXLTime(XLISP_ENV * env);
void init_If(XLISP_ENV * env);
XL_SEXP * if_loop(XLISP_ENV * env,XL_SEXP * s);
void init_IfDef(XLISP_ENV * env);

void init_Lambda(XLISP_ENV * env);
XL_SEXP * _xl_Lambda_Normal(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * _xl_Lambda_Applicative(XLISP_ENV * env,XL_SEXP * s);
void init_Launch(XLISP_ENV * env);
void init_Leaf(XLISP_ENV * env);
void init_ListEval(XLISP_ENV * env);
XL_SEXP * search_and_eval(XLISP_ENV * env,XL_SEXP * d,L_CHAR * sym,char * flags);
XL_SEXP * get_omit_list(L_CHAR * str);
int omit_check(L_CHAR * str,XL_SEXP * lst);
void init_ListLength(XLISP_ENV * env);
void init_Load(XLISP_ENV * env);
XL_SEXP * xl_delay_load(XL_SEXP * s);
void set_sexp_inh(XL_FILE * f,int type,XL_SEXP * d,XL_SEXP * h);
int load_long_char(L_CHAR * ch,STREAM * st);
XL_SEXP *  xl_delay_load_text(XL_SEXP * s);
int set_encoding(XL_SEXP * ret);
void _xx_lock_parse(char*,int);
#define lock_parse()	_xx_lock_parse(__FILE__,__LINE__)
void unlock_parse(char * str);

XL_SEXP * gb_xor(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * gb_lt(XLISP_ENV * e,XL_SEXP * s);
int field_equals(XL_SYM_FIELD * sf_1,XL_SYM_FIELD * sf_2);
XL_SEXP * gb_and(XLISP_ENV * e,XL_SEXP * s);
int default_error_handler(int type,XL_SEXP * s);
void init_parse_system();
void sp_gc_gblisp_lex();
XL_SEXP * gb_not(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * gb_or(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * gb_Neq(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * gb_Or(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * gb_Not(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * gb_Xor(XLISP_ENV * e,XL_SEXP * s);
XL_SEXP * gb_gt(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * gb_push_delay(XL_FILE * f,XL_SEXP * p,int dtype);
int gb_pop_delay(XL_FILE * f);
void gb_file_insert(XL_FILE * f);
void new_entity(XL_FILE * f,L_CHAR * name,L_CHAR * data);
void new_pair(XL_FILE * f);
void set_sexp(XL_FILE * f,int type,XL_SEXP * d);
void new_quote(XL_FILE * f);
void null_pair(XL_FILE * f);
void new_data_set(XL_FILE * f,XL_SEXP * data);
void new_data(XL_FILE * f,XL_SEXP * data);
XL_SEXP * parse_data(XL_FILE * f);
XL_SEXP * parse_quote(XL_FILE * f);
XL_SEXP * parse_pair(XL_FILE * f);
int gb_lex(XL_FILE * f);
void parse_error(XL_FILE * f);
XL_SEXP * _realize_sexp(XL_SEXP * s);
int get_sexp_size(int type);
CS_LIST * search_cs(CS_LIST * cs,L_CHAR code);
int cs_l_char(CS_WORK * w,L_CHAR * str);
int cs_error_on_mem(CS_WORK * w,XL_SEXP * s);
int cs_error(CS_WORK * w,XL_SEXP * s);
int cs_string(CS_WORK * w,XL_SEXP * s);
int cs_symbol(CS_WORK * w,XL_SEXP * s);
int cs_pair_on_mem(CS_WORK * w,XL_SEXP * s);
int cs_pair(CS_WORK * w,XL_SEXP * s);
XL_SEXP * quote_trace_pair(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * quote_trace_symbol(XLISP_ENV * env,XL_SEXP * s);
XL_SEXP * gb_And(XLISP_ENV * e,XL_SEXP * s);
void test_mem(char * str);
void * lex_mrealloc(void * p,int size,void (*func)());
void gb_file_insert(XL_FILE * f);

void gb_file_delete(XL_FILE * f);
int _gb_file_delete(XL_FILE * f);
void set_header(XL_SEXP * s,XL_FILE * f,int type);
void set_header_inh(XL_SEXP * s,XL_FILE * f,int type,XL_SEXP * h);
void token_head(XL_FILE * f);
void put_data(XL_FILE * f,L_CHAR ch);
void reset_yytext(XL_FILE * f);
int get_long_char(L_CHAR * ch,XL_FILE * f);
L_CHAR get_1char(XL_FILE * f,int * ent_flag);
int get_nchar(XL_FILE * f,char * buf,int len);
void put_1char(XL_FILE * f,L_CHAR ch,int ent_flag);
int token_text(XL_FILE * f);
int token_symbol(XL_FILE * f);
int token_raw(XL_FILE * f);
int token_oct_hex(XL_FILE * f);
int token_number(XL_FILE * f);
void push_ent_stack(XL_FILE * f,ENTITY * ent,int mode);
void pop_ent_stack(XL_FILE * f);
int _get_x_text(XL_FILE * f);
int get_x_text(XL_FILE * f);
int get_x_tag(XL_FILE * f);
int get_x_tag_end(XL_FILE * f);
int get_x_tfield(XL_FILE * f);
int get_x_ttext(XL_FILE * f);

int get_token(XL_FILE * f);
void pt_line(XL_FILE * f);
int get_raw_length(XL_FILE * f);
int get_x_symbol(XL_FILE * f);
ENTITY * search_entity(XL_FILE * f,L_CHAR * name);
L_CHAR get_1ent(XL_FILE * f,int * ent_flag);
L_CHAR gb_lex_entity(int * flag,XL_FILE * f,int mode);
int _gb_lex(XL_FILE * f,int ent_mode);
int check_html_emp(XL_SEXP * s);
int __gb_lex(XL_FILE * f);
int check_valid_tag_char(L_CHAR ch);
int check_valid_tag(L_CHAR * str);
int check_valid_string_char(L_CHAR ch);
int check_valid_string(L_CHAR * str);
int gb_save_write(STREAM * st,XL_SEXP * s);
XL_SEXP * gb_geq(XLISP_ENV * env,XL_SEXP * s);
int get_x_number(XL_FILE * f);

L_CHAR * docs_path_search(L_CHAR *f);
L_CHAR * sys_path_search(L_CHAR *f);
L_CHAR * get_xldocs(L_CHAR * f);
int Reg_List_pathpair(L_CHAR * path,L_CHAR * url);
XL_SEXP * get_pathpair(L_CHAR * path);
L_CHAR * get_xlsys_path(URL * u);
L_CHAR * get_xldocs_path(URL * u);
L_CHAR * get_xldocs_apppath(URL * u,char * c);
L_CHAR * get_xlsys_apppath(URL * u,char * c);
L_CHAR * get_sys_path(char *c);

void init_SetDirectory(XLISP_ENV * env);
void init_GetXLpathpair(XLISP_ENV * env);
void init_Let(XLISP_ENV * env);
void init_Thread(XLISP_ENV * env);

void escape_handling(L_CHAR * d);

void init_WritingStyle(XLISP_ENV * env);


#endif
