/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_EX_DRAW_H___
#define ___V_EX_DRAW_H___

#include "v/VDraw.h"

VImage * v_get_image_element(VImage * img,VRect elr);


class VexDraw : public VDraw
{
  public:
	enum { object_type = VO_EDRW };
	virtual unsigned	get_type() const { return object_type; }
	
	enum VexDrawAttr {
		over_bit_mask		= 0x0003 << 16,
		over_none			= 0x0000 << 16,
		over_hilight		= 0x0001 << 16,
		over_hilight_b		= 0x0002 << 16,
		over_img_zero		= 0x0003 << 16,
		
		press_bit_mask		= 0x000c << 16,
		press_none			= 0x0000 << 16,
		press_hilight		= 0x0004 << 16,
		press_hilight_b		= 0x0008 << 16,
		press_img_zero		= 0x000c << 16,
		
		click_bit_mask		= 0x0030 << 16,
		click_none			= 0x0000 << 16,
		click_stay			= 0x0010 << 16,
		click_rotate		= 0x0020 << 16,
		click_rotate_zero	= 0x0030 << 16,
		
		disabled_mask		= 0x00c0 << 16,
		disabled_none		= 0x0000 << 16,
		disabled_ignore		= 0x0040 << 16,
		disabled_hilight	= 0x0080 << 16,
		disabled_img_zero	= 0x00c0 << 16,
		
		ex_behavior			= over_hilight + press_hilight +
								click_rotate_zero + disabled_hilight
	};

	static VexDraw*	create(const VObjectStatus *s, int flags, VExError *err=0) {
			return create(s, flags, 0, err);
	}
	static VexDraw*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VexDraw*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual VError	set_image(VImage* img, VSize min_size = v_default_size);	// change image

	virtual VError	set_images(int n, VImage** imgs, VSize min_size = v_default_size);
	virtual VError	set_image_at(int n, VImage* img);
	virtual VImage*	get_image_at(int n);
	
	virtual bool	mouse_event(VMouseEvent *event);
	
  protected:
	virtual ~VexDraw();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);

	static V_CALLBACK_D(call_ex_mouse_event_handler)
					{ static_cast<VexDraw*>(object)->
						ex_mouse_event_handler(object, user_arg, sys_arg); }
	V_CALLBACK_D(ex_mouse_event_handler);
	
	int			image_num;
	VImage**	images;

  private:
	static VObject *internal_new(){
		return new VexDraw();
	}
};


#endif
