/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_SLIDER_H___
#define ___V_SLIDER_H___

#include "v/VObject.h"

class VSlider : public VObject
{
  public:
	enum { object_type = VO_SLID };
	virtual unsigned	get_type() const { return object_type; }
	
	struct range_set {
		int min, max, step;
	};
	static VSlider*	create(
								const VObjectStatus *s,
								int flags,
								int min,
								int max,
								int step,
								VExError *err=0) {
		range_set arg = {min,max,step};
		return create(s, flags, &arg, err);
	}
	static VSlider*	create(const VObjectStatus *s, int flags, void *arg, VExError *err=0) {
		return static_cast<VSlider*>(
			create_tmp(internal_new, object_type, s, flags, err, arg));
	}
	
	
	virtual VExError		get_status(VObjectStatus *, int flags) const;
	virtual VExError		set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;
	
	int		get_range_min()		{ return min; }
	int		get_range_max()		{ return max; }
	int		get_range_step()	{ return step; }
	
  protected:
	virtual				~VSlider();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void		destroy_do(VObject*);
	
	int max, min, step;

  private:
	static VObject *internal_new(){
		return new VSlider();
	}
};

#endif
