/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_CLIPBOARD_H___
#define ___V_CLIPBOARD_H___

#include "v/v_types.h"

// ========== clipboard management ===========

class VClipboard
{
  public:
	static bool		is_data_type_available(int type);
	static void		set_data_type(int type, int len, void *data, bool clear=true);
	static void *	get_data_type(int type, int &outLen);
	static void		release_data();
	
	static VImage *	convert_from_system_image_data(void *data, int size);
	static void *	convert_to_system_image_data(VImage *img, int *outSize);
	static void		release_system_image_data();
  protected:
	static void *	data;
	static int		data_type;
};



typedef struct _VIM {
	struct _VIM *	parent;
	enum VdataType	sys_type;
} VIM;
typedef struct VdataList {
	struct VdataList *	next;
	class Vdata *		d;
} VdataList;


typedef struct clipboard_list {
	struct clipboard_list *	next;
	void *			sys_data;
	int			sys_size;
	class Vdata *		target;
	VdataList *		vdata_list;
	VIM *			vim;
} ClipBoardList;



// ============= data types ==============

extern SEM cb_lock;

extern VIM VIM_Vdata;

class Vdata
{
  public:
	VIM* get_type() const { return vdata_type; };
	virtual int get_size();
	virtual void store_into_clipboard(Vdata * d=0);
	static ClipBoardList * get_clipboard();
	virtual ~Vdata() {}
  protected:
  	void * mData;
  	int size;
  	int err;
  	VIM * vdata_type;
};

extern VIM VIM_VdataString;

class VdataString : public Vdata
{
  public:
	
	VdataString(const char *str,int * erp=0,bool valid=1);
	VdataString(Vdata *d,int * erp=0,bool valid=1);
	virtual ~VdataString();

	static VdataString * new_from_clipboard();
	static  bool clipboard_available(bool lock_flag=1);

	virtual char * get_VdataString(int * erp=0);
	virtual void store_into_clipboard(Vdata * d=0);
	static ClipBoardList * get_clipboard();
  protected:
};

extern VIM VIM_VdataLString;


class VdataLString : public VdataString
{
  public:

	VdataLString(const L_CHAR *str,int * erp=0,bool valid=1);
	VdataLString(const char *str,int * erp=0,bool valid=1);
	VdataLString(Vdata * d,int * erp=0,bool valid=1);
	virtual ~VdataLString();

	static bool clipboard_available(bool lock_flag=1);
	static VdataLString * new_from_clipboard();

	virtual char * get_VdataString(int * erp=0);
	virtual L_CHAR * get_VdataLString(int * erp=0);

	virtual void store_into_clipboard(Vdata * d=0);
  protected:
};


class VdataImage : public Vdata
{
  public:

	VdataImage(const VImage * img,int * erp=0,bool valid=1);
	VdataImage(Vdata * d,int * erp=0,bool valid=1);
	virtual ~VdataImage();

	static bool clipboard_available(bool lock_flag=1);
	static VdataImage * new_from_clipboard();

	virtual VImage * get_VdataImage(int * erp=0);

	static ClipBoardList * get_clipboard();
	virtual void store_into_clipboard(Vdata * d=0);
  protected:
};



int cmp_VIM(VIM * a,VIM * b);
#define VIM_INCOMP	(-2)
void init_clipboard();
void insert_clipboard_variation(ClipBoardList* c,Vdata * d);
Vdata * delete_clipboard_variation(VIM * v);
Vdata * check_clipboard_variation(VIM * v);
void clear_all_data(ClipBoardList* c);

#endif
