/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___V_H___
#define ___V_H___

#ifdef M_DELETE

#include	"long_char.h"


#define COL_BIT			10
#define COL_MASK		0x3ff

#define C_TRANSPARENT		0x40000000
#define C_DIRTY			0x80000000
#define C_COLOR			0x3fffffff

#define COL(r,g,b)	((r)|((g)<<COL_BIT)|((b)<<(COL_BIT*2)))

#define C_NULL			0x40000000

/*
#define CB_MSB_FIRST	1
#define CB_LSB_FIRST	2
*/

typedef struct vpoint {
	int		x;
	int		y;
} VPOINT;

typedef struct vrect {
	VPOINT		tl;
	VPOINT		br;
} VRECT;

typedef struct verror {
	int		err1;
	int		err2;
} VERROR;

typedef struct v_string_pic {
	VRECT		r;
	short		width;
	short		dir;
#define VSD_U2D		1
#define VSD_L2R		2
#define VSD_R2L		3
	unsigned char *	pic;
} V_STRING_PIC;


XXXXXX
#include	"v/v_types.h"


/* errors */
#ifndef E_OK
#define E_OK		0
#define E_SYS		(-1)
#endif
#define E_VMATCH	(-2)
#define E_PARAM		(-3)

VDISPLAY *
v_open_disp(VERROR * err);

VWINDOW *
v_open_win(VERROR * err,VDISPLAY * d,int x,int y,int w,int h);
void
v_get_window_attributes(VERROR *,VWINDOW_ATTRIBUTES *,VWINDOW *);
void v_clear_window_content(VERROR * err, VWINDOW *win);

VOBJECT *
v_create_image(VERROR * err,VWINDOW * win,int x,int y,int w,int h);
void
v_set_image(VERROR * err,VOBJECT * obj,int x,int y,int w,int h);
int
v_image_minrect(VRECT * ,VOBJECT *);
void *
v_get_and_new_image(int *,VOBJECT *);
void
v_part_redraw_image(VOBJECT * obj,int x,int y,int w,int h);
void
v_redraw_image(VOBJECT * vi);

VOBJECT *
v_create_text(VERROR * err,VWINDOW * win,
		unsigned long,unsigned long,
		int,int,
		int,int,L_CHAR*,int);
int
v_set_text(VERROR *,VOBJECT *,unsigned long,unsigned long,
		L_CHAR *,int);
void
v_move_text(VOBJECT *,int,int);
int
v_text_minrect(VRECT*,VOBJECT*);

int check_inside(VRECT,VPOINT);

void
v_get_string_pic(V_STRING_PIC *,VDISPLAY *,L_CHAR *,int,int);

int
v_select_box(VOBJECT * obj,VPOINT st,VPOINT end,int flag);

void
marge_vrect(VRECT *,VRECT *);

void
v_set_display_key(char *);

void
v_loop(VDISPLAY * d);

int
check_event(VWINDOW * win,int type,int subtype);

extern void (*null_handler)();
extern void (*invoke_handler)();

void _redraw(VWINDOW * win,int x,int y,int w,int h);
void _button(VWINDOW * win,int subtype,int t,int x,int y);
void _null();
void _invoke();

#endif

#endif
