/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___RESOURCE_H___
#define ___RESOURCE_H___

#include	"task.h"
#include	"xllisp.h"
#include	"tree_cache.h"
#include	"avt.h"
#include	"r64.h"
#include	"rect_tree.h"
#include	"gbgraph.h"
#include	"utils.h"
#include	"queue.h"

#define RES_HASH_SIZE	101

#define SURP_DEPTH	4
#define SURP_NOS	(8*SURP_DEPTH+1)

#define PIXEL_ENHANCED	env.pixel_enhanced
#define PIXEL_ENHANCED_MONITOR	env.pixel_enhanced_monitor
#define LOD_START	1
#define LOD_PITCH	1.5

#define LIMIT_RESOLUTION_RATE	5

#define DM_RATE	0.01
#define DM_DIM 	2


#define DEFAULT_DGB_PIXEL	1024


#define DEFAULT_ONMAP_INDICATE_SIZE	60

/*
#define MAX_CLIENT_CONNECTION	10
#define T_MATRIX_SIZE	16
*/
#define STS_MSG_TBL_LENGTH	20


/* priority */
#define PRI_BROWSE	50
#define PRI_WF_BASE	1
#define PRI_WF_FREE	100

/* resource id */
#define RT_COORDINATE		1
#define RT_MAP			2
#define RT_DRAW_GB		3
#define RT_PIXEL_MAP_R64	4
#define RT_MAX			5

#define RT_LUSTER	RT_PIXEL_MAP_R64
#define RT_VECTOR	RT_DRAW_GB

#define RT_OFFSET		0
#define RM_COORDINATE		(1<<(RT_COORDINATE+RT_OFFSET))
#define RM_PIXEL_MAP_R64	(1<<(RT_PIXEL_MAP_R64+RT_OFFSET))
#define RM_DRAW_GB		(1<<(RT_DRAW_GB+RT_OFFSET))
#define RM_MAP			(1<<(RT_MAP+RT_OFFSET))

#define RIDC_SPECIAL	0
#define RIDC_COORD	RT_COORINATE
#define RIDC_MAP	RT_MAP
#define RIDC_VECT	RT_DRAW_GB
#define RIDC_LAST	RT_PIXEL_MAP_R64
#define RIDC_MAX	RT_MAX

#define RID_LENGTH	0x00010000

#define RID_SPECIAL_S	0x00000002
#define RID_SPECIAL_E	RID_LENGTH

#define RID_INDICATED_COORD	2
#define RID_HIDE_COORD		3
#define RID_INIT		4
#define RID_INTERFACE		5
#define RID_RADAR		6
#define RID_RAW_IMAGE		7
#define RID_SP_MAX		8

/* gv-new-resource */
#define NR_NEW		0
#define NR_CLEAR	1
#define NR_KEEP		2

/* map_from_XX method */
#define MFF_F_MTH	0x03
#define MFF_R_MTH	0x0c

#define MFF_F_MR	0x01
#define MFF_R_MR	0x04


typedef struct ring_type {
	struct ring_type *	next;
	struct ring_type *	prev;
} RING_TYPE;

#define INIT_RING(x)	\
	(x)->next = (x)->prev = (x);
#define INSERT_RING(x,n)	\
	(n)->prev = (x);	\
	(n)->next = (x)->next;	\
	(n)->prev->next = (n);	\
	(n)->next->prev = (n);
#define DELETE_RING(n)	\
	(n)->prev->next = (n)->next;	\
	(n)->next->prev = (n)->prev;
#define R_NEXT(t,n)	((t)(n)->next)
#define R_PREV(t,n)	((t)(n)->prev)


typedef int WF_ID;

typedef struct ov_header {
	union overlay *		next;
	int			type;
#define OVT_OVERWRAP		0
#define OVT_TRANSPARENT		1
#define OVT_CSUPERINPOSE	2
	void			(*filter)();
	URL			url;
} OV_HEADER;

typedef struct ov_transparent {
	OV_HEADER		h;
	REAL1			rate;
} OV_TRANSPARENT;

typedef struct ov_csuperinpose {
	OV_HEADER		h;
	REAL1			rate;
	long			key[3];
	unsigned int		key_radius;
	unsigned int		inpose_radius;
} OV_CSUPERINPOSE;

typedef union overlay {
	OV_HEADER		h;
	OV_TRANSPARENT		t;
	OV_CSUPERINPOSE		cs;
} OVERLAY;

#define GROUP_ID		unsigned short

typedef struct surp_set {
	GB_POINT		ptr[SURP_NOS];
	REAL1			reso[SURP_NOS];
	GROUP_ID		group[SURP_NOS];
} SURP_SET;

typedef struct group_set_list {
	struct group_set_list *	next;
	int			x_cnt;
	int			y_cnt;
	GROUP_ID		prev_gid;
	GROUP_ID		gid;
} GROUP_SET_LIST;

typedef struct group_set {
	GROUP_ID		next_id;
	GROUP_SET_LIST *	list;
} GROUP_SET;

typedef struct obj_header {
	unsigned int	code;
#define MAIN_CODE	0xffffff00
#define SUB_CODE	0x000000ff
#define USER_SUBCODE	0x00000080
#define INFO_SUBCODE	0x000000ff
	int		type;
#define OT_POLYGON2D	1
#define OT_MARK		2
#define OT_MAX		3
	GB_PALETTE	palette;
	int		flags;
#define OF_INFO		0x000000ff
#define OF_INFO_STS	0x00000003
#define OF_INFO_NOCHECK	0x00000000
#define OF_INFO_FETCH	0x00000001
#define OF_INFO_PROC	0x00000002
#define OF_ONMAP_REQ	0x00000008

#define OF_INFO_SCHEME	0x000000f0
#define OF_INFO_NULL	0x00000000
#define OF_INFO_URI	0x00000010
#define OF_INFO_XML	0x00000020
#define OF_INFO_HTML	0x00000030
#define OF_INFO_ERROR	0x00000040

	XL_SEXP *	info_org;
	XL_SEXP *	info_card;
	XL_SEXP *	info_onmap;
	L_CHAR *	name;
	GB_RECT		minrect;
	REAL1		onmap_resolution;
	REAL1		req_resolution;
	short		lod_min;
	short		lod_max;

	int		touch;
} OBJ_HEADER;

typedef struct point_list {
	RING_TYPE	h;
	union obj *	obj;
	struct point_list * dm_next;
	int		no;
	int		lod_min;
	int		lod_max;
	GB_POINT	pt;
} POINT_LIST;

typedef struct polygon2d {
	OBJ_HEADER	h;
	int		type;
#define PT_CLOSE	1
#define PT_OPEN		2
	RING_TYPE	point_list;
} POLYGON2D;

typedef struct mark {
	OBJ_HEADER	h;
	L_CHAR *	path;
	int		t_color;
	int		align;
#define AG_TB_MASK	0x0000000f
#define AG_TB_TOP	0x00000000
#define AG_TB_CENTER	0x00000001
#define AG_TB_BOTTOM	0x00000002

#define AG_LR_MASK	0x000000f0
#define AG_LR_LEFT	0x00000000
#define AG_LR_CENTER	0x00000010
#define AG_LR_RIGHT	0x00000020
	GB_POINT	pt;
	GB_RECT		drect;
} MARK;

typedef union obj {
	OBJ_HEADER	h;
	POLYGON2D	polygon2d;
	MARK		mark;
} OBJ;


typedef struct clip {
	struct clip *		next;
	short			type;
#define CT_OUT			1
#define CT_IN			2
	short			shape;
#define CST_RECT		1
	union {
		GB_RECT			rect;
	}			d;
} CLIP;

typedef struct map {
	RING_TYPE		h;
	short			depth;
	short			flags;
#define MF_BROWSE		0x0001
	union resource *	src;
	union resource *	dest;
	union resource *	map_file;
	URL			src_url;
	URL			dest_url;
	URL			map_url;
	unsigned int		mod_time_org;
	unsigned int		mod_time;
	unsigned int		cindex_time;
	GB_RECT			cindex_mr;

	CLIP *			clip;
} MAP;


typedef struct bib_list {
	struct bib_list *	next;
	int			inherit;
	L_CHAR *		bib_namespace;
	L_CHAR *		qualifier;
	L_CHAR *		type;
	L_CHAR *		data;
} BIB_LIST;

typedef struct note {
	struct note *		next;
	int			type;
#define NT_COLOR		1
#define NT_IMAGE		2
	L_CHAR *		img;
	int			fill_color;
	int			line_color;
	L_CHAR *		data;
	L_CHAR *		url;
} NOTE;



typedef struct res_header {
	union resource * entry_next;
	union resource * target_next;
	union resource * no_next;
	int		type;
	/* type equal to RT_.... parameter */
	URL		entry;
	URL		target;
	int		no;
	int		flags;
#define RF_DELETE		0x00000001
#define RF_DELETE_ACCEPT	0x00000002

#define RF_FIX			0x00000004

#define RF_CACHE		0x00000010
#define RF_UNCACHE		0x00000020
#define RF_ERROR		0x00000040

#define RF_COMPLETE		0x00000100
#define RF_LOAD_EXTEND		0x00000200
#define RF_LOAD_EXTEND_PROC	0x00000400

#define RF_INDICATE		0x03000000
#define RF_I_OFF		0x00000000
#define RF_I_ON			0x01000000
#define RF_I_AUTO		0x02000000
	unsigned int	modify;
	GB_RECT		minrect;

	XL_SEXP *	meta;
	int		initial_status;
	XL_SEXP *	initial_error;
	int		incremental_status;
#define RS_IDLE		0
#define RS_LOAD		1
#define RS_ERROR	2
	XL_SEXP *	incremental_error;
	int		error_time;
	int		error_expire;
	BIB_LIST *	bib;
	NOTE *		notes;
	REAL1		visible_resolution;
	REAL1		limit_resolution;
	COORDINATE_UNIT cu;

	XL_SEXP *	data;
} RES_HEADER;


typedef struct pixel_map_r64 {
	RES_HEADER	h;
	REAL1		dpm;
	unsigned char	type;
	/*
		'P'	R64 RGB
		'G'	R64 Gray Scale
		'B'	R64 Bitmap
		'0'	CR 64 sqare RGB
		'1'	CR 128 sqare RGB
		'2'	CR 256 sqare RGB
	*/
	int		width[32];
	int		height[32];
	int		max_level;
	TREE_CACHE	tc;
	int		loop_no;
} PIXEL_MAP_R64;

typedef struct coordinate {
	RES_HEADER	h;
	int		flags;
#define CF_FIX_LIMIT_RESO	0x00000001
	int		geometory_type;
#define GT_T_SHIFT		24
#define GT_D_SHIFT		16
#define GT_A_SHIFT		0

#define GT_T_MAX		3
#define GT_D_MAX		4

#define GT_T_MASK		0xff000000
#define GT_D_MASK		0x00ff0000
#define GT_A_MASK		0x00000003

#define GT_T_2D			0x01000000
#define GT_T_GLOBE_SUR		0x02000000
#define GT_D_PITAGOLAS 		0x00010000
#define GT_D_GLOBE		0x00020000
#define GT_D_ELLIPSOID		0x00030000

#define GT_A_X_FOR		0x00000000
#define GT_A_X_REV		0x00000001
#define GT_A_Y_FOR		0x00000000
#define GT_A_Y_REV		0x00000002

#define GT_A_MATH		(GT_A_X_FOR|GT_A_Y_FOR)
#define GT_A_COMP		(GT_A_X_FOR|GT_A_Y_REV)

#define GT_E2D		(GT_T_2D|GT_D_PITAGOLAS)
#define GT_ELLIPSOID	(GT_T_GLOBE_SUR|GT_D_ELLIPSOID)
	double *	geometory_param;

//	REAL1		limit_resolution;
	RING_TYPE	map_children;
	RING_TYPE	map_parents;
	OVERLAY *	ov;
	REAL1		weight;
	L_CHAR *	mode;
	XL_SEXP *	initial_cmd;
	XL_SEXP *	button_action;

	int *		cid;
	L_CHAR *	body;
	L_CHAR *	body_pri;

	L_CHAR *	relation_master;
	L_CHAR *	relation_slave;

	CLIP *			clip;
} COORDINATE;



typedef struct rect_pair {
	int		x;
	int		y;
} RECT_PAIR;

typedef struct draw_matrix {
	RING_TYPE		h;
	struct draw_matrix **	up;
	RECT_PAIR		ofs;
	short			level;
	short			flags;
#define DMF_REQUIRED		0x0001
#define DMF_REQUEST		0x0002
#define DMF_LOADED		0x0004
	struct draw_matrix *	m[DM_DIM][DM_DIM];
	union resource *	r;
	struct draw_matrix *	parent;
	WF_ID			wfid;
	int			loop_no;
	int			access;

	int			get_handle_time;
	short			get_level;

	struct point_list *	dm_point_list;
} DRAW_MATRIX;

typedef struct style_file {
	struct style_file *	next;
	struct style_file *	prev;
	L_CHAR *		name;
	short			state;
#define SFS_UNLOAD		0
#define SFS_LOADED		1
#define SFS_LOCKED		2
#define SFS_ERROR		3
	short			type;
#define SFT_XL			1
#define SFT_XL_ENV		2
#define SFT_XSL			3
	XL_SEXP *		style;
} STYLE_FILE;

typedef struct info_scheme {
	struct info_scheme *	next;
	L_CHAR *		scheme;
	short			card_type;
	short			onmap_type;
	/* these are same as STYLE_FILE.type */
	L_CHAR *		card_style;
	L_CHAR *		onmap_style;
} INFO_SCHEME;

/* type for get_info_style */
#define IS_CARD		2
#define IS_ONMAP	3

typedef struct tile_id_list {
	int			code;
	int			inner_id;
} TILE_ID_LIST;

typedef struct draw_gb {
	RES_HEADER	h;
	int		type;
#define DGT_LOAD	1
#define DGT_PDB		2
#define DGT_TILE	3
	short		level;
	short		pdb_lock;
	int		pdb_lock_task;
	int		pdb_err_sensitive;
	char *		pdb_lock_file;
	int		pdb_lock_line;
	unsigned int	pdb_lock_time;
	int		pdb_lock_pri;
	int		pdb_lock_gc_flag;
	int		flags;
#define DGF_POLY	0x00000001
#define DGF_INFO	0x00000002
#define DGF_MARK	0x00000004
	REAL1		resolution;
	AVT_NODE *	obj_code_tree;
	RECT_TREE	obj_rect_tree;
	GB_POINT	matrix_ofs;
	DRAW_MATRIX *	dm;

	GB_POINT *	pitch_list;
	int		loop_no;
	SYS_QUEUE	ir_que;
	INFO_SCHEME *	ischeme;
	REAL1		onmap_indicate_size;
	short		hit_level;
	short		hit_outofcircle;
	char		tile_query;

	int		tile_id;
	AVT_NODE *	tile_list;
	GB_RECT		tile_dirty_rect;

	struct d_buf *	dbuf;
} DRAW_GB;

typedef struct map_point_list {
	RING_TYPE	h;
	L_CHAR *	tag;
	GB_POINT	src;
	GB_POINT	dest;
} MAP_POINT_LIST;

typedef struct triangle {
	struct triangle *	next;
	struct triangle *	c; /* correspond */
	MAP_POINT_LIST *	ptl[3];
	GB_POINT		ptp[3];
	AFFEN2D			a;
	REAL1			resolution_rate;
	GB_RECT			minrect;
} TRIANGLE;

typedef struct triangle_set {
	int			sts;
#define TS_NOSET	0
#define TS_FIX		1
#define TS_TMP		2
	int			cnt;
	AFFEN2D			a;
	GB_RECT			minrect;
	REAL1			resolution_rate;
	TRIANGLE *		tri_list;
} TRIANGLE_SET;

typedef struct map_parameter {
	int	type;
#define MT_MOVE		1
#define MT_ROTATE	2
#define MT_LINEAR	3
#define MT_TRIANGLE	4
	REAL1	resolution_rate;
	union {
		GB_POINT	ptr;
		AFFEN2D		affen;
		TRIANGLE_SET	tri;
	}	opt;
} MAP_PARAMETER;

typedef struct res_map {
	RES_HEADER	h;
	URL		src;
	URL		dest;
	COORDINATE_UNIT	cu_src;
	COORDINATE_UNIT	cu_dest;
	RING_TYPE	point_list;
	MAP_PARAMETER		param_forward;
	MAP_PARAMETER		param_reverse;
} RES_MAP;

typedef union resource {
	RES_HEADER	h;
	COORDINATE	c;
	PIXEL_MAP_R64	pr64;
	DRAW_GB		draw_gb;
	RES_MAP		map;
} RESOURCE;


typedef struct meta_cache {
	struct meta_cache *	next;
	URL			url;
	XL_SEXP *		meta;
	XL_SEXP *		data;
} META_CACHE;


typedef struct mh_linear {
	AFFEN2D			forward;
	AFFEN2D			reverse;
	REAL1			forward_reso_rate;
	REAL1			reverse_reso_rate;
} MH_LINEAR;

typedef struct mh_parallel_projection {
	REAL1			forward_vol[3][3];
	REAL1			reverse_vol[3][3];
	AFFEN2D			forward_sur;
	AFFEN2D			reverse_sur;
	REAL1			forward_rate;
	REAL1			lambda;
	REAL1			phi;
} MH_PARALLEL_PROJECTION;

typedef struct map_history {
	short			type;
#define MHT_MAP		0
#define MHT_LINEAR	1
#define MHT_PP		2
	short			dir;
#define MHD_FORWARD	0
#define MHD_REVERSE	1
	struct map_history *	next;
	struct map_history *	prev;
	union {
		RESOURCE *		map;
		MH_LINEAR		ln;
		MH_PARALLEL_PROJECTION	pp;
	} d;
} MAP_HISTORY;


typedef struct ov_arg {
	char *		redraw;
	unsigned long *	dest;
	int		d_w;
	int		d_h;
	int		d_x;
	int		d_y;
	int		d_x_w;
	int		d_y_h;

	unsigned long *	src;
	int		s_w;
	int		s_h;
	int		s_x;
	int		s_y;
} OV_ARG;


typedef XL_SEXP * (*GV_FUNC)();


typedef struct indicate {
	struct indicate *	next;
	URL			url;
	RESOURCE *		target;
	int			flags;
#define IF_COORDINATE		0x00000001
#define IF_OBJECT		0x00000002
	int			status;
#define IS_COORDINATE		0x00000001
#define IS_OBJECT		0x00000002
	GB_POINT		result;
	L_CHAR *		unit;
	RESOURCE *		res_object;
} INDICATE;

typedef struct draw_work {
	struct draw_work *	parent;
	GB_POINT *		pt_list;
	REAL1 * 		pt_reso;
	unsigned long *		pixels;
	int			size;
	GB_RECT *		rectondisp;
	MAP *			map;
	MAP_HISTORY *		mh;
	int			method;
	SURP_SET		surp;

	int			flags;

	int			ses;
	GB_RECT			draw_rect;
	int			draw_lod;
	WF_ID			wfid;
	RESOURCE *		resource;
	REAL1			limit_reso;
	GB_POINT		limit_ptr;

	int			data_request;
} DRAW_WORK;


typedef struct brawse_work_route {
	char			check;
	char			last_check;
	MAP_HISTORY *		mh;
	int			route_len;
} BROWSE_WORK_ROUTE;

typedef struct browse_work {
	int			type;
#define BWT_CHILDREN		1
/*
#define BWT_ROUTE		3
*/
	SURP_SET		surp;

	WF_ID			base;
	MAP_HISTORY *		mh;
/*
	REAL1			resolution;
	REAL1			search_resolution;
*/
	int			ses;

	URL *			route;
	int			route_len;
	BROWSE_WORK_ROUTE *	rr;
	int			load_max;
} BROWSE_WORK;

typedef struct get_point_work {
	GB_POINT		pt;
	GB_POINT		org;
	int			button;
#define GPB_PRESS		1
#define GPB_ON			2
	INDICATE *		indicate_list;
} GET_POINT_WORK;

typedef struct check_work {
	int			max_coord_level;
	RESOURCE *		resource;
	int			flags;
#define CWF_RESOURCE 	0x00000001
	int			type[RT_MAX];
	int			opt[RT_MAX];
	int			coord_level;
} CHECK_WORK;


struct load_resource_work;

typedef struct resource_type_list {
	char *		tag_name;
	char *		file_type;
	int		flags;
#define RTF_TARGET	0x00000001
	int		resource_type_num;
	char *		(*loading_function)(int,struct load_resource_work*);
	int		(*setup_function)();
} RESOURCE_TYPE_LIST;



typedef struct load_resource_work {

	Q_HEADER		h;
	int		que_pri;
#define Q_PRI_CRD	0
#define Q_PRI_CRD_META	1
#define Q_PRI_OTHER	2

#define Q_PRI_OBJ	0
#define Q_PRI_ROUTING	3
#define Q_PRI_RADAR	6

/* neccesary to set */

	struct load_resource_work * req_next;
	struct load_resource_work * que_next;
	int		option;
#define LRO_FULL	0
#define LRO_UNIT	1
	URL		url;

/* return values */

	int		err;
#define LRWE_OK		0
#define LRWE_ERROR_FORMAT1	(-1)
#define LRWE_ERROR_FORMAT2	(-2)
#define LRWE_ERROR_FORMAT3	(-3)
#define LRWE_ERROR_NO_RES_TYPE	(-4)
#define LRWE_ERROR_HEADER_INIT	(-5)
#define LRWE_ERROR_BODY_INIT	(-6)
#define LRWE_ERROR_NO_ROOT_XML	(-7)
#define LRWE_ERROR_BODY_EVAL	(-8)
#define LRWE_ERROR_URL		(-9)
#define LRWE_ERROR_GET1		(-10)
#define LRWE_ERROR_GET2		(-11)
#define LRWE_HANDLING	1
#define LRWE_NOTUSE	2
#define LRWE_COMPLETE	3
#define LRWE_DUP	4
	int		terminate;

	RESOURCE *	result;
	XL_SEXP *	meta_result;
	int		(*wup_func)();
	int		wup;

/* for system */

	XL_SEXP *	data_result;
	L_CHAR *	target;
	RESOURCE_TYPE_LIST * rt;
	XL_SEXP *	_meta_ret;
	char		_data_flag;
	char *		_mode;

	struct load_resource_work *	first_next;

	struct load_resource_work *	same_list;
	struct load_resource_work *	same_next;

} LOAD_RESOURCE_WORK;


typedef int (*GBV_FUNC)();

#define GBF_DRAW	1
#define GBF_GET_POINT	2
#define GBF_FREE	3
#define GBF_BROWSE	4
#define GBF_SELECT	5
#define GBF_OLIST	6
#define GBF_CHECK	7
#define GBF_EXIT_LOCK	8
#define GBF_MAX		9

extern XLISP_ENV * draw_gb_top;
extern XLISP_ENV * map_top;
extern GBV_FUNC resource_table[RT_MAX][GBF_MAX];
extern GBV_FUNC object_table[OT_MAX][GBF_MAX];
extern float temp_pos[5];
#ifndef ___OVERLAY_C___
extern OVERLAY default_overlay;
#endif

RESOURCE * new_resource_entry(int,URL *);
void delete_resource_entry(RESOURCE*);
int set_resource_target(RESOURCE * r,URL * u);
RESOURCE * search_resource_by_entry(URL *);
RESOURCE * search_resource_by_target(URL *);
RESOURCE * search_resource_by_no(int);
XL_SEXP * get_meta_cache(URL *,char *);
XL_SEXP * get_meta_cache_str(L_CHAR*,char *);
META_CACHE * new_meta_cache(URL * u,XL_SEXP *s,char type);
RESOURCE * load_resource(int ses,URL *,int);
int browse_resource(RESOURCE *,BROWSE_WORK *);
OBJ * search_obj(RESOURCE *,unsigned int);
OBJ * new_object(RESOURCE *,int,unsigned int);

void map_conv_reverse(RESOURCE *,GB_POINT * ,REAL1 * ,int);
void map_conv_forward(RESOURCE *,GB_POINT *,REAL1 *,int);
void map_from_flame(MAP_HISTORY * mh,GB_POINT * ptr,REAL1 * reso,int size);
void map_from_resource(MAP_HISTORY * mh,
	GB_POINT * ptr,REAL1 * reso,int size);
MAP_HISTORY * new_mh(RESOURCE * ,short);
MAP_HISTORY * add_mh(MAP_HISTORY *,MAP_HISTORY *);
MAP_HISTORY * rev_mh(MAP_HISTORY *);
MAP_HISTORY * copy_mh(MAP_HISTORY *);
void free_mh(MAP_HISTORY*);
MAP_HISTORY * optimize_mh(MAP_HISTORY * mh);
OVERLAY * new_overlay(int,URL *);
OVERLAY * search_overlay(URL *);

REAL1 puseudo_rate(REAL1 m[2][2]);
int cross_rect_circle(GB_RECT * rect,GB_POINT p,REAL1 r);
void convert_circle_reverse(
	GB_POINT * 	ret_pt,
	REAL1 *	ret_r,
	GB_POINT	pt,
	REAL1		r,
	MAP *		m);
void convert_circle_forward(
	GB_POINT * 	ret_pt,
	REAL1 *	ret_r,
	GB_POINT	pt,
	REAL1		r,
	MAP *		m);
REAL1
convert_resolution_forward(
	REAL1		reso,
	GB_POINT	pt,
	RESOURCE *	m);
REAL1
convert_resolution_reverse(
	REAL1		reso,
	GB_POINT	pt,
	RESOURCE *	m);
GB_POINT
map_conv_tric(REAL1 *res,MAP_PARAMETER * mp,GB_POINT p);
REAL1
map_radius(MAP_PARAMETER * mp,GB_POINT c,REAL1 radius);


RESOURCE * get_resource_ptr(XL_SEXP **,XLISP_ENV * e,XL_FILE * f,int ln);
XL_SEXP *
get_resource_status_header(RESOURCE ** rp,XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a_env,XL_SYM_FIELD * sf);
XL_SEXP * get_object_header(OBJ*);
XL_SEXP * get_resource_element(RESOURCE*);
void set_gv_sp_resource(int id,XLISP_ENV * env);
void set_gv_resource(int id,XLISP_ENV * env);

void load_resource_list(LOAD_RESOURCE_WORK *,int,int);
void _load_resource_list(int ses);


#define CRS_NOTHING		0
#define CRS_LOADING		1
#define CRS_EXIST		4
#define CRS_ERROR		5
#define CRS_MAX			6

void free_lrw_que_next(LOAD_RESOURCE_WORK *);
void free_lrw_req_next(LOAD_RESOURCE_WORK *);
LOAD_RESOURCE_WORK * new_lrw(LOAD_RESOURCE_WORK * w);
RESOURCE * get_lrw(
	LOAD_RESOURCE_WORK * w,
	URL * u);
void set_lrw_err(LOAD_RESOURCE_WORK *,int);
int lr_extend(RESOURCE * r,int (*)());

XL_SEXP * load_meta(int ses,char * mode,L_CHAR * target);
void _load_meta_list(int ses,char * mode,int data_flag,
	int next_type,LOAD_RESOURCE_WORK * w);

MAP_HISTORY * cons_mh(RESOURCE * m,short dir,MAP_HISTORY * mh);
MAP_HISTORY * resolve_mappath(int ses,L_CHAR * org,L_CHAR * target,int);
BIB_LIST * insert_bib_list(BIB_LIST * root,BIB_LIST * bl);
BIB_LIST * copy_bib_list(BIB_LIST * bl);
BIB_LIST * search_bib_list(BIB_LIST * bl,
		   L_CHAR * bib_namespace,int inherit,L_CHAR * qualifier);
int cmp_bib_lst(BIB_LIST *,BIB_LIST * );
RESOURCE * get_map_between(int,L_CHAR * obj,L_CHAR * crd);
RESOURCE * get_map_between2(RESOURCE * obj,RESOURCE * crd);

void call_gv_event(int rno,L_CHAR * msg);

int xx_lock_pdb_lock(RESOURCE * r,int es,char * file,int line);
#define lock_pdb_lock(r,es)	xx_lock_pdb_lock(r,es,__FILE__,__LINE__)
void unlock_pdb_lock(RESOURCE * r);
void pdb_err_sensitive(RESOURCE *,int);
int test_pdb_err_sensitive(RESOURCE * r);

COORDINATE_UNIT *
set_c_unit(COORDINATE_UNIT *,L_CHAR * url,L_CHAR * system,L_CHAR * unit);
void setup_c_unit(COORDINATE_UNIT * up,int ses,L_CHAR * url,
	XL_SEXP * meta,XL_SYM_FIELD * sf);
COORDINATE_UNIT * search_c_unit(L_CHAR * url);

void set_surp(SURP_SET *,GB_RECT * ,REAL1 reso);
GB_RECT * get_surp_rect(int *,SURP_SET *,RESOURCE *);
GB_RECT * get_surp_rect_rate(int *,SURP_SET * surp,REAL1 rate,RESOURCE *r);
REAL1 get_surp_reso(SURP_SET * surp);
REAL1 surp_reso_max(REAL1 * reso);
REAL1 surp_reso_min(REAL1 * reso);

int resource_check(L_CHAR * url_str,int);
void dispose_lrw(LOAD_RESOURCE_WORK * w,int terminate);
void test_map_reso(char* str,REAL1 * reso,int size,int data);

void
adjust_lambda(L_CHAR * unit,REAL1 min_point,
	GB_POINT * pt_list,REAL1 * reso,GROUP_ID * group,int size);

/*
extern RING_TYPE	resource_h;
extern RW_LOCK		resource_lock;
*/
extern SEM 		status_lock;

int check_lrw_status(LOAD_RESOURCE_WORK * w,int * sts,int len,int flags,int mask);

void init_coordinate();
void gc_gv_coordinate(RESOURCE * r);
void load_children(RESOURCE * r,XL_SEXP * s);
int get_fi(REAL1 * ret,XL_SEXP * d);
void load_parents(RESOURCE * r,XL_SEXP * s);
int get_cid_from_sexp(COORDINATE * c,XL_SEXP * cid);
XL_SEXP * gv_new_coordinate(RESOURCE * r,XL_SEXP * s,int ds);
void load_coordinate_option();

void free_mapping_from_sd(RESOURCE * src,RESOURCE * dest);
void init_luster();
XL_SEXP * get_r64_meta(XL_SEXP * s);
XL_SEXP *get_cr_meta(XL_SEXP * s);
XL_SEXP * gv_new_luster(RESOURCE * r,XL_SEXP * s,int ds);
void gv_new_luster_option(RESOURCE * r,int r64_level);

void gc_gv_draw(RESOURCE * r);
void init_vector();
int gc_gv_draw_func(AVT_NODE * a);
XL_SEXP * gv_new_vector(RESOURCE * r,XL_SEXP * s,int ds);
void new_vector_option1(RESOURCE * r,int ds);
void new_vector_option2(RESOURCE * r,int ds,int level);

void init_gv_resource(XLISP_ENV * env);
void set_note(
	RESOURCE * r,
	int type,
	L_CHAR * img,
	int fill_color,
	int line_color,
	L_CHAR * data,
	L_CHAR * url);
void gc_gv_resource();
void gc_gv_resource_onlock();
int gc_gv_resource_clock();
void gc_gv_resource_unlock();

void new_qualifier(
	RESOURCE * r,
	int inh,
	L_CHAR * q,
	L_CHAR * ns,
	XL_SYM_FIELD * sf);
void bib_inheritance(RESOURCE * r,XL_SEXP * b,XL_SEXP * sym,
	XL_SYM_FIELD * ns_sf);
void free_bib_list(BIB_LIST * bl);
int cmp_bib_list(BIB_LIST * b1,BIB_LIST * b2);
L_CHAR * get_ns(XL_SYM_FIELD * ns_sf,L_CHAR * sym);
void set_bib(RESOURCE * r,XL_SEXP * meta);
XL_SEXP * get_bib_data(RESOURCE * r,L_CHAR * ns,int inh,L_CHAR * q);
REAL1 get_value(XL_SEXP ** retp,RESOURCE * r,XL_SEXP * res_data);
XL_SEXP *set_visible_resolution(RESOURCE * r,XL_SEXP * rec);
XL_SEXP * set_resource_header(RESOURCE * r,XL_SEXP * meta);
void new_resource_option();
XL_SEXP * get_init_status_info(RESOURCE * r);
XL_SEXP * get_inc_status_info(RESOURCE * r);
XL_SEXP * get_indicate_status(RESOURCE * r);
XL_SEXP * get_image_notes(RESOURCE * r,XL_SEXP * ret);
XL_SEXP * get_color_notes(RESOURCE * r,XL_SEXP * ret);


XL_SEXP * get_map_list(RING_TYPE * rt);
MAP * get_mapping(RESOURCE * r,URL * u);
void free_clip(CLIP * c);
void free_map_parameter(MAP_PARAMETER * mp);
XL_SEXP * gv_new_map(RESOURCE * r,XL_SEXP * s,int ds);
void draw_map();
void get_point_map();
void lock_map();
void unlock_map();
GB_POINT _map_conv_triangle(REAL1 *res,MAP_PARAMETER * mp,GB_POINT p);
GB_POINT map_conv_triangle(REAL1 *res,MAP_PARAMETER * mp,GB_POINT p);
void map_conv_forward_ln(MAP_HISTORY * mh,GB_POINT * p,REAL1 * reso,int size);
void map_conv_reverse_ln(MAP_HISTORY * mh,GB_POINT * p,REAL1 * reso,int size);
void map_conv_reverse_pp(MAP_HISTORY * mh,GB_POINT * p,REAL1 * reso,int size);
void map_conv_forward_pp(MAP_HISTORY * mh,GB_POINT * p,REAL1 * reso,int size);
GROUP_SET * new_gs(REAL1 * reso,GROUP_ID * g,int size);
GROUP_ID new_group(GROUP_SET * gs,GROUP_ID prev,int x_cnt,int y_cnt);
void free_gs(GROUP_SET * gs);
void print_surp(SURP_SET * surp);
GROUP_ID surp_group_optimize(SURP_SET * surp);
int opt_mh_affen2d(AFFEN2D * a);
int opt_mh_i_map(RESOURCE * r);
MAP_HISTORY * optimize_mh_identical(MAP_HISTORY * mh);
void set_me(REAL1 m[2][2]);
void copy_ln_map2mh(MAP_HISTORY * mh);
MAP_HISTORY * optimize_mh_linear(MAP_HISTORY * mh);
void get_rol_matrix(AFFEN2D * a,
	GB_POINT src,GB_POINT dest,REAL1 rol);
int get_rol(AFFEN2D * m,
	GB_POINT s1,GB_POINT d1,
	GB_POINT s2,GB_POINT d2);
void set_param_angle(RESOURCE * r,REAL1 rol);
XL_SEXP * angle(XLISP_ENV * e,XL_SEXP * s);
int set_reload(RESOURCE * r);
void inverse_affen(AFFEN2D * ret,AFFEN2D * a);
XL_SEXP * horizontal_affen(XLISP_ENV * e,XL_SEXP * s);
void set_param(RESOURCE * r);
XL_SEXP * point_map(XLISP_ENV * e,XL_SEXP * s);
void set_triangle_minrect(TRIANGLE * t);
void marge(TRIANGLE ** list1,TRIANGLE ** list2,int st,int len,int cnt);
TRIANGLE * get_middle(TRIANGLE_SET * ts);
void set_outside(TRIANGLE_SET * ts,TRIANGLE * t);
XL_SEXP * triangle_map(XLISP_ENV * e,XL_SEXP * s);


XL_SEXP * root_tag_func(XLISP_ENV * env,XL_SEXP * s,
	XLISP_ENV * a_env,XL_SYM_FIELD * sf,
	XLISP_ENV * sp);
void root_tag(XLISP_ENV * env,L_CHAR * name,XLISP_ENV * sp_env);
void gv_set_status_option(RESOURCE * r);

void delete_meta_cache(URL * u);

void set_inc_status(RESOURCE * r,int status);
void set_init_status(RESOURCE * r,int status);
void set_init_status_error(RESOURCE * r,XL_SEXP * er);
void set_inc_status_error(RESOURCE * r,XL_SEXP * er);

void loading_resource_xl();
void init_resource();
void init_coordinate_unit();
void init_map();
void init_load_resource();

int get_new_rid(int type);
unsigned int get_lchar_key(L_CHAR * a);
unsigned int get_rhash_key(URL * u);
META_CACHE * _search_meta_cache(unsigned int * kp,URL * u);
META_CACHE * _new_meta_cache(URL * u,XL_SEXP *s,char type);
void _delete_meta_cache(URL * u);
RESOURCE * _new_resource_entry(int type,URL * entry);
RESOURCE * _search_resource_by_entry(URL * u);
RESOURCE * _search_resource_by_target(URL * u);
RESOURCE *
_search_resource_by_no(int no);
XL_SEXP *_get_meta_cache(URL * u,char * type);

int _set_resource_target(RESOURCE * r,URL * u);
void _delete_resource_entry(RESOURCE * r);

int ov_setup(OV_ARG * d,OV_ARG * s);
unsigned long ovf_csuperinpose(OVERLAY * ov,unsigned long b,unsigned long a);

void _gc_lrw(LOAD_RESOURCE_WORK * w);
void _gc_lrw_get(LOAD_RESOURCE_WORK * w);
LOAD_RESOURCE_WORK * delete_res_queue(SYS_QUEUE * q,L_CHAR * key);
LOAD_RESOURCE_WORK * delete_res_queue_handle_max(SYS_QUEUE * q,L_CHAR * key);
void check_lrw_req_next(LOAD_RESOURCE_WORK * w);
void check_lrw_que_next(LOAD_RESOURCE_WORK * w);
RESOURCE_TYPE_LIST * get_resource_type(RESOURCE_TYPE_LIST * rt,char * tag);
RESOURCE_TYPE_LIST * get_resource_type_by_no(RESOURCE_TYPE_LIST * rt,int no);
LOAD_RESOURCE_WORK * _search_first_list(LOAD_RESOURCE_WORK * w);
LOAD_RESOURCE_WORK * _search_first_list_by_url(L_CHAR * url,int opt);
void _delete_first_list(LOAD_RESOURCE_WORK * w);
void _insert_first_list(LOAD_RESOURCE_WORK * w);
void _release_first_list(LOAD_RESOURCE_WORK * w);
void release_first_list(LOAD_RESOURCE_WORK * w);
void _res_end_op_extend(LOAD_RESOURCE_WORK * w,int err,RESOURCE * r,int clear);
void res_end_op_extend(LOAD_RESOURCE_WORK * w,int err,RESOURCE * r,int clear);
void _res_end_op(LOAD_RESOURCE_WORK * w,int err,RESOURCE * r);
void res_end_op(LOAD_RESOURCE_WORK * w,int err,RESOURCE * r);
void _res_end_op_2(LOAD_RESOURCE_WORK * w,int err,RESOURCE * r);
void res_end_op_2(LOAD_RESOURCE_WORK * w,int err,RESOURCE * r);
void _load_meta_list_insert(int ses,SYS_QUEUE * q,
		char * mode,int data_flag,
		LOAD_RESOURCE_WORK * w,
		int wait_flag);
void print_work(char * str,LOAD_RESOURCE_WORK * w);
LOAD_RESOURCE_WORK * 
__load_meta_list_delete(int * ret_f,int ses,SYS_QUEUE * q,L_CHAR * key,
	int extend_flag);
LOAD_RESOURCE_WORK *
_load_meta_list_delete(int ses,SYS_QUEUE * q,L_CHAR * key);
void _load_resource_list1(int ses,LOAD_RESOURCE_WORK * w,L_CHAR * key);
void _resource_fix_wait(RESOURCE * r);
void _lr_extend_insert(int ses,LOAD_RESOURCE_WORK * w,L_CHAR * key);
int lrw_len_req_next(LOAD_RESOURCE_WORK * wp);
int lrw_len_que_next(LOAD_RESOURCE_WORK * wp);
void rs_cache_setup_c_unit(int ses,URL * u,COORDINATE_UNIT * cu);
void lrl_test(LOAD_RESOURCE_WORK * w);
int get_que_pri(URL * u);
void wait_setup_resource(LOAD_RESOURCE_WORK * w);
void free_resource_entry(RESOURCE * r);
int _check_lrw_status(LOAD_RESOURCE_WORK * w,int * sts,int len,
	int flags,int mask);
void _resource_cache_invoke(RESOURCE * r);
void resource_cache_invoke();
void gc_gv_resource_onlock();
int gc_gv_resource_clock();
void gc_gv_resource_unlock();
void gc_gv_resource();



void map_test_trace(MAP_HISTORY * mh);
int map_test(GB_POINT * ptr,REAL1 * reso,int w,int size,char * msg);


XL_SEXP *
gv_set_status_coordinate(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf);
void test_draw_object_whole();

#endif

