/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___LC_ENCODE_H___
#define ___LC_ENCODE_H___

#include	"long_char.h"

#define LCZ_1BC_ASCII		0x00000000

#define LCZ_1BC_JISX0201	0xe0000100

#define LCZ_1BC_VISCII		0xe0001000
#define LCZ_1BC_TCVN5712	0xe0001100
#define LCZ_1BC_TIS620		0xe0001200

#define LCZ_1BC_ISO8859_1	0xe0002100
#define LCZ_1BC_ISO8859_2	0xe0002200
#define LCZ_1BC_ISO8859_3	0xe0002300
#define LCZ_1BC_ISO8859_4	0xe0002400
#define LCZ_1BC_ISO8859_5	0xe0002500
#define LCZ_1BC_ISO8859_6	0xe0002600
#define LCZ_1BC_ISO8859_7	0xe0002700
#define LCZ_1BC_ISO8859_8	0xe0002800
#define LCZ_1BC_ISO8859_9	0xe0002900
#define LCZ_1BC_ISO8859_10	0xe0002a00
#define LCZ_1BC_ISO8859_11	0xe0002b00
#define LCZ_1BC_ISO8859_12	0xe0002c00
#define LCZ_1BC_ISO8859_13	0xe0002d00
#define LCZ_1BC_ISO8859_14	0xe0002e00
#define LCZ_1BC_ISO8859_15	0xe0002f00

#define LCZ_1BC_MAC_ARABIC_LR	0xe0003000
#define LCZ_1BC_MAC_ARABIC_RL	0xe0003100

#define LCZ_1BC_MAC_CENTEURO	0xe0003200
/*#define LCZ_1BC_MAC_CHINSIMP	0xe0003300*/
/*#define LCZ_1BC_MAC_CHINTRAD	0xe0003400*/
#define LCZ_1BC_MAC_CORPCHAR	0xe0003500
#define LCZ_1BC_MAC_CROATIAN	0xe0003600
#define LCZ_1BC_MAC_CYRILLIC	0xe0003700

#define LCZ_1BC_MAC_DEVANAGA	0xe0003800
#define LCZ_1BC_MAC_DEVANAGA_CN	0xe0003900

#define LCZ_1BC_MAC_DINGBATS	0xe0003a00

#define LCZ_1BC_MAC_FARSI_LR	0xe0003c00
#define LCZ_1BC_MAC_FARSI_RL	0xe0003d00

#define LCZ_1BC_MAC_GREEK	0xe0003e00

#define LCZ_1BC_MAC_GUJARATI	0xe0004000
#define LCZ_1BC_MAC_GUJARATI_CN	0xe0004100

#define LCZ_1BC_MAC_GURMUKHI	0xe0004200
#define LCZ_1BC_MAC_GURMUKHI_CN	0xe0004300

#define LCZ_1BC_MAC_HEBREW_LR	0xe0004400
#define LCZ_1BC_MAC_HEBREW_RL	0xe0004500

#define LCZ_1BC_MAC_ICELAND	0xe0004600
/*#define LCZ_1BC_MAC_JAPANESE	0xe0004700*/
#define LCZ_1BC_MAC_KEYBOARD	0xe0004800
/*#define LCZ_1BC_MAC_KOREAN	0xe0004900*/
#define LCZ_1BC_MAC_ROMAN	0xe0004a00
#define LCZ_1BC_MAC_ROMANIAN	0xe0004b00
#define LCZ_1BC_MAC_SYMBOL	0xe0004c00
#define LCZ_1BC_MAC_THAI	0xe0004d00
#define LCZ_1BC_MAC_TURKISH	0xe0004e00
#define LCZ_1BC_MAC_UKRAINE	0xe0004f00

#define LCZ_1BC_WIN874  LCZ_1BC_MAC_THAI
#define LCZ_1BC_WIN1250 LCZ_1BC_ISO8859_2
#define LCZ_1BC_WIN1251 LCZ_1BC_ISO8859_5
#define LCZ_1BC_WIN1252 LCZ_1BC_ISO8859_1
#define LCZ_1BC_WIN1253 LCZ_1BC_ISO8859_7
#define LCZ_1BC_WIN1254 LCZ_1BC_ISO8859_9
#define LCZ_1BC_WIN1255 LCZ_1BC_ISO8859_8
#define LCZ_1BC_WIN1256 LCZ_1BC_ISO8859_6
#define LCZ_1BC_WIN1257 LCZ_1BC_ISO8859_4
/* #define LCZ_1BC_WIN1258 (Vietnam) */


#define LCZ_2BC_JISX0208_1990	0xc0010000
#define LCZ_2BC_JISX0208_1983	0xc0030000
#define LCZ_2BC_JISX0208_1978	0xc0040000
#define LCZ_2BC_JISX0212_1990	0xc0050000

#define LCZ_2BC_UNICODE_v1_1_JP	0xc0060000
#define LCZ_2BC_UNICODE_v1_1_TW	0xc0070000
#define LCZ_2BC_UNICODE_v1_1_CN	0xc0080000
#define LCZ_2BC_UNICODE_v1_1_KR	0xc0090000

#define LCZ_2BC_UNICODE_v2_0_JP	0xc00a0000
#define LCZ_2BC_UNICODE_v2_0_TW	0xc00b0000
#define LCZ_2BC_UNICODE_v2_0_CN	0xc00c0000
#define LCZ_2BC_UNICODE_v2_0_KR	0xc00d0000

#define LCZ_2BC_UNICODE_v3_0_JP	0xc00e0000
#define LCZ_2BC_UNICODE_v3_0_TW	0xc00f0000
#define LCZ_2BC_UNICODE_v3_0_CN	0xc0100000
#define LCZ_2BC_UNICODE_v3_0_KR	0xc0110000

#define LCZ_2BC_UNICODE_v1_1_UN	0xc0120000
#define LCZ_2BC_UNICODE_v2_0_UN	0xc0130000
#define LCZ_2BC_UNICODE_v3_0_UN	0xc0140000

#define LCZ_2BC_UNICODE_v1_1_UN_CN 0xc0150000
#define LCZ_2BC_UNICODE_v2_0_UN_CN 0xc0160000
#define LCZ_2BC_UNICODE_v3_0_UN_CN 0xc0170000

#define LCZ_2BC_MAC_CHINSIMP	0xc0200000
#define LCZ_2BC_MAC_CHINTRAD	0xc0210000
#define LCZ_2BC_MAC_JAPANESE	0xc0220000
#define LCZ_2BC_MAC_KOREAN	0xc0230000

#define LCZ_2BC_WIN932 LCZ_2BC_MAC_JAPANESE
/*#define LCZ_2BC_WIN_936 (Simplified Chinese GBK)*/
#define LCZ_2BC_WIN949 LCZ_2BC_MAC_KOREAN
/*#define LCZ_2BC_WIN950 (Traditional Chinese Big5)*/

#define LCZ_2BC_GB2312		0xc0240000
#define LCZ_2BC_BIG5		0xc0250000
#define LCZ_2BC_JOHAB		0xc0260000
#define LCZ_2BC_WANSUNG		0xc0270000

#define LCZ_3BC_NICHIBUN	0xc0020000
#define LCZ_3BC_KONJAKU		0x81000000

#define LCZ_2BC_LCCODE		0xdfff0000

#define LCC_INTERNAL		(LCZ_2BC_LCCODE|0x0000)
#define LCC_ASCII		(LCZ_2BC_LCCODE|0x0001)
#define LCC_ISO646		(LCZ_2BC_LCCODE|0x0002)
#define LCC_ISO8859_1		(LCZ_2BC_LCCODE|0x0003)
#define LCC_ISO8859_2		(LCZ_2BC_LCCODE|0x0004)
#define LCC_ISO8859_3		(LCZ_2BC_LCCODE|0x0005)
#define LCC_ISO8859_4		(LCZ_2BC_LCCODE|0x0006)
#define LCC_ISO8859_5		(LCZ_2BC_LCCODE|0x0007)
#define LCC_ISO8859_6		(LCZ_2BC_LCCODE|0x0008)
#define LCC_ISO8859_7		(LCZ_2BC_LCCODE|0x0009)
#define LCC_ISO8859_8		(LCZ_2BC_LCCODE|0x000a)
#define LCC_ISO8859_9		(LCZ_2BC_LCCODE|0x000b)
#define LCC_ISO8859_10		(LCZ_2BC_LCCODE|0x000c)
#define LCC_UNICODE_v1_1	(LCZ_2BC_LCCODE|0x000d)
#define LCC_UNICODE_v2_0	(LCZ_2BC_LCCODE|0x000e)
#define LCC_UNICODE_v3_0	(LCZ_2BC_LCCODE|0x000f)
#define LCC_ISO10646_v1_1	(LCZ_2BC_LCCODE|0x0010)
#define LCC_ISO10646_v2_0	(LCZ_2BC_LCCODE|0x0011)
#define LCC_ISO10646_v3_0	(LCZ_2BC_LCCODE|0x0012)


#define LCC_UCS2		(LCZ_2BC_LCCODE|0x0013)
#define LCC_UCS4		(LCZ_2BC_LCCODE|0x0014)
#define LCC_UTF7		(LCZ_2BC_LCCODE|0x0015)
#define LCC_UTF8		(LCZ_2BC_LCCODE|0x0016)
#define LCC_UTF16		(LCZ_2BC_LCCODE|0x0017)


#define LCC_ISO8859_11		(LCZ_2BC_LCCODE|0x0018)
#define LCC_ISO8859_12		(LCZ_2BC_LCCODE|0x0019)
#define LCC_ISO8859_13		(LCZ_2BC_LCCODE|0x001a)
#define LCC_ISO8859_14		(LCZ_2BC_LCCODE|0x001b)
#define LCC_ISO8859_15		(LCZ_2BC_LCCODE|0x001c)

#define LCC_VISCII		(LCZ_2BC_LCCODE|0x0100)
#define LCC_TCVN5712		(LCZ_2BC_LCCODE|0x0101)

#define LCC_TIS620		(LCZ_2BC_LCCODE|0x0200)

#define LCC_JISX0201_ROMAN	(LCZ_2BC_LCCODE|0x0300)
#define LCC_JISX0201_KATAKANA	(LCZ_2BC_LCCODE|0x0301)
#define LCC_JISX0208_1978	(LCZ_2BC_LCCODE|0x0302)
#define LCC_JISX0208_1983	(LCZ_2BC_LCCODE|0x0303)
#define LCC_JISX0208_1990	(LCZ_2BC_LCCODE|0x0304)
#define LCC_JISX0208_1997	(LCZ_2BC_LCCODE|0x0305)
#define LCC_JISX0212		(LCZ_2BC_LCCODE|0x0306)
#define LCC_JP_EUC		(LCZ_2BC_LCCODE|0x0307)
#define LCC_EUC_JP		(LCZ_2BC_LCCODE|0x0308)
#define LCC_Shift_JIS		(LCZ_2BC_LCCODE|0x0309)
#define LCC_ISO2022_JP		(LCZ_2BC_LCCODE|0x030a)
#define LCC_ISO2022_JP_1	(LCZ_2BC_LCCODE|0x030b)
#define LCC_ISO2022_JP_2	(LCZ_2BC_LCCODE|0x030c)
#define LCC_KONJAKU		(LCZ_2BC_LCCODE|0x0380)
#define LCC_NICHIBUN		(LCZ_2BC_LCCODE|0x0381)

#define LCC_GB2312		(LCZ_2BC_LCCODE|0x0400)
#define LCC_CN_GB		(LCZ_2BC_LCCODE|0x0401)
#define LCC_GBK			(LCZ_2BC_LCCODE|0x0402)
#define LCC_HZ_GB2312		(LCZ_2BC_LCCODE|0x0403)
#define LCC_GB7589		(LCZ_2BC_LCCODE|0x0404)
#define LCC_GB7590		(LCZ_2BC_LCCODE|0x0405)
#define LCC_ITU_T_T101_ChinesePrimarySet	\
				(LCZ_2BC_LCCODE|0x0406)
#define LCC_GBT12345		(GBZ_2BC_LCCODE|0x0407)
#define LCC_ISO2022_CN		(LCZ_2BC_LCCODE|0x0408)
#define LCC_ISO2022_CN_EXT	(LCZ_2BC_LCCODE|0x0409)

#define LCC_BIG5		(LCZ_2BC_LCCODE|0x0500)
#define LCC_CNS11643		(LCZ_2BC_LCCODE|0x0501)
#define LCC_CNS11643_1988	(LCZ_2BC_LCCODE|0x0502)
#define LCC_CNS11643_1992	(LCZ_2BC_LCCODE|0x0503)
#define LCC_CCCII		(LCZ_2BC_LCCODE|0x0504)
#define LCC_EUC_TW		(LCZ_2BC_LCCODE|0x0505)

#define LCC_KSX1001		(LCZ_2BC_LCCODE|0x0600)
#define LCC_KSX1002		(LCZ_2BC_LCCODE|0x0601)
#define LCC_EUC_KR		(LCZ_2BC_LCCODE|0x0602)
#define LCC_ISO2022_KR		(LCZ_2BC_LCCODE|0x0603)
#define LCC_JOHAB		(LCZ_2BC_LCCODE|0x0604)
#define LCC_UHC			(LCZ_2BC_LCCODE|0x0605)
#define LCC_WANSUNG		(LCZ_2BC_LCCODE|0x0606)

#define LCC_ERROR		(LCZ_2BC_LCCODE|0x0ffff)

#define LCZ_4BC_ISO10646_v2_0	0x00000000

#endif
