/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___GPS_PORT_H___
#define ___GPS_PORT_H___

#include	"stream.h"

typedef struct SERIAL_PORT_INFO {
	char *	name;
	void *	info;
	struct SERIAL_PORT_INFO *	next;
} SERIAL_PORT_INFO;


SERIAL_PORT_INFO *	lookup_serial_port();

STREAM * open_serial_port(SERIAL_PORT_INFO *info, int bps);


typedef struct GPS_GET_SENTENCE
{
	STREAM *s;
	int cur, start, end;
	char buf[4096];
} GPS_GET_SENTENCE;


GPS_GET_SENTENCE *	gps_get_sentence_start(SERIAL_PORT_INFO *port);
void	gps_get_sentence_end(GPS_GET_SENTENCE *ggs);
const char *	gps_get_sentence(GPS_GET_SENTENCE *ggs);

typedef struct GPGGA {
	int hour, min, ndeg, edeg, quality, sats, adgps, dgps_st;
	float sec, nmin, emin, elev;
} GPGGA;

typedef struct GPRMC {
	int year, month, day, hour, min, ndeg, edeg;
	float sec, nmin, emin, speed, direction;
	char state;
} GPRMC;

typedef struct GPGSA {
	char mode;
	int state;
} GPGSA;

typedef struct PGRME {
	float hpe, vpe, epe;
} PGRME;


#endif
