/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___FILESPACE_H___
#define ___FILESPACE_H___

#include	"pdb.h"

typedef struct freelist {
	PN_FREELIST		f;
	unsigned int		fofs;
	struct freelist *	next;
} FREELIST;

unsigned int alloc_filespace(PDB *,PN_HEADER * h);
void free_filespace(PDB *,unsigned int);
void * get_file_record(unsigned int *,PDB *,short);
void * xx_read_filespace(PDB *,unsigned int,char * __file,int __line);
#define read_filespace(p,ofs)	xx_read_filespace((p),(ofs),__FILE__,__LINE__)
int write_filespace(PDB *,void *);
void flush_filespace(PDB * );
void close_filespace(PDB * p);
int fa_write(int fd,void * d,int len);

void change_endian_freelist_to_net(PN_FREELIST * f);
void change_endian_freelist_to_host(PN_FREELIST * f);

#ifndef OPEN_FILESPACE
PDB * open_filespace(char * filename,int oflags,int mode,int flags,...);
#else
PDB* open_filespace(char * filename,int oflags,int mode,
	int flags,int type,char * encoding,
	unsigned int linear,unsigned int linear_length);
#endif

void change_endian_file_header(PN_FILE_HEADER * f);
void free_freelist(FREELIST * f);
void load_freelist(PDB * p,PN_FREELIST * f,unsigned int fofs);
void save_freelist(PDB * p,PN_FREELIST * f,unsigned int fofs);
FREELIST * next_freelist(PDB * p,FREELIST * f);
FREELIST * insert_freelist(PDB * p,FREELIST * f,unsigned int fofs,int size);
int delete_freelist(unsigned int * retp,PDB * p,FREELIST * b);
void truncate_check(PDB * p,unsigned int length);
int check_freelist(PDB * p);
int check_filespace(PDB * p);
void init_cache();




#endif

