/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___FAVT64_H___
#define ___FAVT64_H___

#include "pdb64.h"


#define FAVT_CACHE_SIZE	100

typedef struct favt_header64 {
	struct favt_header64 *	next;
	struct favt_header64 * 	prev;
	PDB64 *			p;
	unsigned int		fofs;
	short			type;
	unsigned short		flags;
#define FAF_DIRTY	0x0001
#define FAF_LOCK	0x0002
} FAVT_HEADER64;

typedef struct favt_ptr64 {
	unsigned int		fofs;
	int			type;
	void *			ptr;
	unsigned short		flags;
} FAVT_PTR64;

typedef struct favt_node64 {
	FAVT_HEADER64	h;
	FAVT_PTR64	small;
	FAVT_PTR64	large;
	FAVT_PTR64 *	parent;
	struct favt_root64 * root;
	int		level;
	int		data_len;
	void *		data;
} FAVT_NODE64;

typedef struct favt_root64 {
	FAVT_HEADER64	h;
	int		type;
	void		(*endian_func)();
	FAVT_PTR64	node;
} FAVT_ROOT64;

typedef struct bound_list64 {
	struct bound_list64 *	next;
	void *			data;
	int			data_len;
} BOUND_LIST64;

FAVT_ROOT64 * favt_alloc_root64(PDB64 *,int,void (*)());
FAVT_NODE64 * favt_alloc_node64(FAVT_ROOT64 *,void *,int);
FAVT_NODE64 * favt_insert64(FAVT_ROOT64 *,FAVT_PTR64 *,FAVT_NODE64 * ,int (*)());
FAVT_NODE64 * favt_delete64(FAVT_ROOT64 *,FAVT_PTR64 *,void *,int (*)());
FAVT_NODE64 * favt_search64(FAVT_ROOT64 * p,FAVT_NODE64 * a,void * data,int (*cmp)());
BOUND_LIST64 *
	favt_bound_search64(FAVT_ROOT64 *,FAVT_NODE64 *,void *,void *,int (*)());
void free_bound_list64(BOUND_LIST64 *);
FAVT_ROOT64 * get_root64(PDB64 *,unsigned int,void (*)());
void favt_test64(FAVT_ROOT64 * p,FAVT_NODE64 * a,int (*cmp)());
FAVT_NODE64 * root_node64(FAVT_ROOT64 * r);
void favt_free_root64(FAVT_ROOT64 * rt);
void favt_free_node64(FAVT_NODE64 * rt);
int favt_trace_from_large64(FAVT_ROOT64 * p,FAVT_NODE64 * a,int (*func)(),void * work);
int favt_trace_from_small64(FAVT_ROOT64 * p,FAVT_NODE64 * a,int (*func)(),void * work);
void favt_lock64(FAVT_HEADER64 *);
void favt_unlock64(FAVT_HEADER64 *);

void check_cache64(char * str) ;
void
flush_favt_cache64(PDB64 * p) ;
#endif
