/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "gbview.h"
#include "win_flame.h"
#include "xlerror.h"

XL_SEXP * xl_gv_flame_set_overlay();

void
init_gv_flame_set_overlay(XLISP_ENV * env)
{
	set_env(env, l_string(std_cm,"gv-flame-set-overlay"),
			get_func_prim(xl_gv_flame_set_overlay,FO_APPLICATIVE,0,4,4));
}

XL_SEXP *
xl_gv_flame_set_overlay(
		XLISP_ENV * e,
		XL_SEXP * s,
		XLISP_ENV * a,
		XL_SYM_FIELD * sf)
{
XL_SEXP * u, * flags,* mask;
int ret;
GBVIEW_FLAME * gf;
	
	gf = get_gf_from_sf(sf);

	u = get_el(s,1);
	flags = get_el(s,2);
	mask = get_el(s,3);
	if ( get_type(u) != XLT_STRING || get_type(flags) != XLT_INTEGER )
		goto type_missmatch;

	ret = wf_set_overlay(gf,u->string.data,flags->integer.data,mask->integer.data);
	return get_integer(ret,0);

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gv-flame-set-overlay"),
		List(n_get_string("type missmatch"),
			-1));
}
