/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xl.h"
#include	"pmd.h"
#include	"xlerror.h"


typedef struct period {
	GB_TIME		from;
	GB_TIME		to;
} PERIOD;

typedef struct cmp_buf {
	int		type;
#define CBT_STRING	0
#define CBT_GB_TIME	1
#define CBT_PERIOD	2
#define CBT_MAX		3
	union {
		L_CHAR * 	str;
		GB_TIME		gb_t;
		PERIOD		p;
	} d;
} CMP_BUF;

int
check_filter_cmp(XL_SEXP ** retp,
	L_CHAR * t1,
	L_CHAR * d1,
	L_CHAR * t2,
	L_CHAR * d2,
	XL_SEXP * filter)
{
CMP_BUF cb1,cb2;
	*retp = 0;
	if ( t1 == 0 || t2 == 0 ) {
		*retp = get_error(
			filter->h.file,
			filter->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"pmd-query"),
n_get_string("invalid parameter (qualifier compare : type is required"));
		return -1;
	}
	if ( l_strcmp(t1,l_string(std_cm,"W3C-DTF")) == 0 ) {
		cb1.type = CBT_GB_TIME;
		w3c_dtf_to_gb_time(&cb1.d.gb_t,n_string(std_cm,d1));
	}
	else {
		cb1.type = CBT_STRING;
		cb1.d.str = d1;
	}
	if ( l_strcmp(t2,l_string(std_cm,"W3C-DTF")) == 0 ) {
		cb2.type = CBT_GB_TIME;
		w3c_dtf_to_gb_time(&cb2.d.gb_t,n_string(std_cm,d2));
	}
	else {
		cb2.type = CBT_STRING;
		cb2.d.str = d2;
	}
	if ( cb1.type != cb2.type ) {
		*retp = get_error(
			filter->h.file,
			filter->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"pmd-query"),
			n_get_string("type missmatch (qualifier compare)"));
		return -1;
	}
	switch ( cb1.type ) {
	case CBT_STRING:
		return l_strcmp(cb1.d.str,cb2.d.str);
	case CBT_GB_TIME:
		return cmp_gb_time(&cb1.d.gb_t,&cb2.d.gb_t);
	default:
		er_panic("check_filter_cmp(1)");
	}
	return 0;
}



int
check_filter_bound(XL_SEXP ** retp,
	L_CHAR * t1,
	L_CHAR * d1,
	L_CHAR * t2,
	L_CHAR * d2,
	XL_SEXP * filter)
{
CMP_BUF cb1,cb2;
	*retp = 0;
	if ( t1 == 0 || t2 == 0 ) {
		*retp = get_error(
			filter->h.file,
			filter->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"pmd-query"),
n_get_string("invalid parameter (qualifier compare : type is required"));
		return -1;
	}
	if ( l_strcmp(t1,l_string(std_cm,"W3C-DTF")) == 0 ) {
		cb1.type = CBT_PERIOD;
		get_content_period_w3c_dtf(d1,&cb1.d.p.from,&cb1.d.p.to);
	}
	else {
		cb1.type = CBT_STRING;
		cb1.d.str = d1;
	}
	if ( l_strcmp(t2,l_string(std_cm,"W3C-DTF")) == 0 ) {
		cb2.type = CBT_PERIOD;
		get_content_period_w3c_dtf(d2,&cb2.d.p.from,&cb2.d.p.to);
	}
	else {
		cb2.type = CBT_STRING;
		cb2.d.str = d2;
	}
	if ( cb1.type != cb2.type ) {
		*retp = get_error(
			filter->h.file,
			filter->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"pmd-query"),
			n_get_string("type missmatch (qualifier compare)"));
		return -1;
	}

/*
fflush(stdout);
ss_printf("d1 %ls - d2 %ls\n",d1,d2);
ss_printf("1-gb_time %f:%i:%i %f:%i:%i\n",
	cb1.d.p.from.year,
	cb1.d.p.from.month,
	cb1.d.p.from.date,
	cb1.d.p.to.year,
	cb1.d.p.to.month,
	cb1.d.p.to.date);
ss_printf("2-gb_time %f:%i:%i %f:%i:%i\n",
	cb2.d.p.from.year,
	cb2.d.p.from.month,
	cb2.d.p.from.date,
	cb2.d.p.to.year,
	cb2.d.p.to.month,
	cb2.d.p.to.date);
*/
	switch ( cb1.type ) {
	case CBT_STRING:
		return l_strcmp(cb1.d.str,cb2.d.str);
	case CBT_PERIOD:
		if ( cmp_gb_time(&cb1.d.p.from,&cb2.d.p.to) > 0 )
			return -1;
		if ( cmp_gb_time(&cb1.d.p.to,&cb2.d.p.from) < 0 )
			return -1;
		return 0;
	default:
		er_panic("check_filter_cmp(1)");
	}
	return 0;
}

