/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___GBMP_H___
#define ___GBMP_H___

#include	"long_char.h"
#include	"avt.h"
#include	"xl.h"
#include	"gb.h"

/*
#define STACK_INTERVAL		60
*/

#define TQT_CRD		1
#define TQT_MAP		2
#define TQT_TMP		3
#define TQT_MPC		4
#define TQT_LMP		5
#define TQT_DMAP	6
#define TQT_FMAP	7
#define TQT_SMAP	8
#define TQT_LGC		9
#define TQT_MAX		10

#define TQL_ACRP	0
#define TQL_LUMP	1
#define TQL_NORMAL	2
#define TQL_MAX		3

typedef struct tick_que {
	struct tick_que *	next;
	unsigned int		invoke_time;
	int			type;
	L_CHAR * 		filename;
} TICK_QUE;



typedef struct tque_header {
	AVT_NODE *	tick_que;
	AVT_NODE *	name_que;
} TQUE_HEADER;

typedef struct tq_statistics {
	unsigned int	comesoon;
	int		maps;
	int		tqt_cnt[TQT_MAX];
} TQ_STATISTICS;

typedef struct mp_task_env {
	int		ses;
} MP_TASK_ENV;


typedef struct mp_task_t {
	Q_HEADER 	h;
	int		ins_time;
	TICK_QUE * 	tq;
	void		(*op)(MP_TASK_ENV *,struct mp_task_t *);
 	void		(*free_t)(struct mp_task_t *);
} MP_TASK_T;

void insert_tick_que
	(unsigned int time,L_CHAR * filename,int type,int level);
TICK_QUE * delete_tick_que(int level);
void free_tick_que(TICK_QUE * tq);
void push_tq(L_CHAR *filename,int type);
TICK_QUE * pop_tq();
unsigned int get_comesoon();
XL_SEXP *
local_fetch(unsigned int * mod,URL * u,char * prefix);

XL_SEXP * get_cindex_que();

void	init_tick_que();
void tick_que_statistics(TQ_STATISTICS * w);

int mp_counter();
void trace_mapping();
void check_my_acrp(int ses,L_CHAR * filename);
int ping_mapping(int ses,MP_TASK_T * tt,int force);
void trace_crd_mapping();
int get_idle_interval();
void lump_gc_path(int ses);
int tick_lump(TICK_QUE * t,unsigned int tim);
void check_my_lump(int ses,L_CHAR * filename);
int get_map_nos();



#endif

