/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "machine/include.h"
#include "memory_debug.h"
#include "xl.h"
#include "server_work.h"
#include "stream.h"

L_CHAR * get_sys_path(char *);

XL_SEXP *
get_swork(char * filename)
{
L_CHAR * path , * fullpath;
char * cpath;
STREAM * st;
        path = get_sys_path(SWORK_DIR);
	cpath = ln_copy_str(std_cm,path);
        u_mkdir(cpath,0755);
        chmod(cpath,0755);
	fullpath = get_append_path(path,filename);
	d_f_ree(path);
        cpath = ln_copy_str(std_cm,fullpath);
        st = s_open_file(cpath,O_RDONLY);
        d_f_ree(fullpath);
	if ( st == 0 )
		return 0;
	return init_parse(st,l_string(std_cm,filename),
			l_string(std_cm,filename));
}

int
set_swork(char * filename,XL_SEXP * data)
{
L_CHAR * path , * fullpath;
char * cpath;
STREAM * st;
        path = get_sys_path(SWORK_DIR);
	cpath = ln_copy_str(std_cm,path);
        u_mkdir(cpath,0755);
        chmod(cpath,0755);
        fullpath = get_append_path(path,filename);
	d_f_ree(path);
        cpath = ln_copy_str(std_cm,fullpath);
        st = s_open_file(cpath,O_RDWR|O_CREAT|O_TRUNC,0644);
        d_f_ree(fullpath);					
	if ( st == 0 )
		return -1;
	print_sexp(st,data,PF_INDENT|PF_MULTI_ROOT);
	s_printf(st,"\n");
	s_close(st);
	return 0;
}


