/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"acrp.h"

void
err_check_mpt_entry_dir(ACRP_DIR * d,char * str,int ei,int di)
{
	if ( d->hops < 0 )
		return;
	if ( d->hops == 0 ) {
		if ( d->map ) {
			if ( d->map[0] ) {
				fprintf(stderr,"%s %i %i ",str,ei,di);
				er_panic("check_mpt(1)");
			}
		}
		if ( d->crd ) {
			if ( d->crd[0] ) {
				fprintf(stderr,"%s %i %i ",str,ei,di);
				er_panic("check_mpt(2)");
			}
		}
	}
	else {
		if ( d->map ) {
			if ( d->map[0] < 0x20 ) {
				fprintf(stderr,"%s %i %i ",str,ei,di);
				er_panic("check_mpt(3)");
			}
		}
		if ( d->crd ) {
			if ( d->crd[0] < 0x20 ) {
				fprintf(stderr,"%s %i %i ",str,ei,di);
				er_panic("check_mpt(4)");
			}
		}
	}
}

void
err_check_mpt_entry(ACRP_ENTRY * e,char * str,int ei)
{
int i;

	if ( e->pri ) {
		for ( i = 0 ; i < 12 ; i++ ) {
			if ( e->pri[i] < '0' )
				goto err;
			if ( e->pri[i] > '7' )
				goto err;
			continue;
		err:
			fprintf(stderr,"%s %s ",str,n_string(std_cm,e->pri));
			er_panic("check_mpt entry");
		}
	}

	if ( e->dir[0].hops < 0 )
		return;
	if ( e->pri == 0 ) {
		fprintf(stderr,"%s %i ",str,ei);
		er_panic("check_mpt empty pri(4)");
	}
	for ( i = 0 ; i < ACRP_DIR_NOS ; i ++)
		err_check_mpt_entry_dir(&e->dir[i],str,ei,i);
	if ( e->dir[1].hops >= 0 ) {
		fprintf(stderr,"%s %i ",str,ei);
		er_panic("check_mpt entry");
	}
}


void
err_check_mpt(MAP_PATH_TABLE * m,char * str)
{
MAP_PATH_TABLE * m1;
 int i;
	for ( ; m ; ) {
		m1 = m->next;
		for ( i = 0 ; i < ACRP_SUBID_NOS ; i ++ )
			err_check_mpt_entry(&m->ent[i],str,i);
		m = m1;
	}
}


