/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>

#include "v/VLayout.h"
#include "VApplication.h"

extern HWND get_active_dialog();
extern int translate_accel(MSG *msg);

bool doing_layout = false;
DWORD current_time;

extern "C" {

#include "machine/gb_windows.h"
#include "machine/msequence.h"
#include "pri_level.h"
#include "task.h"

extern "C" int ms_loop_1();
int v_loop_tid = 0;

V_CALLBACK_D(do_layout)
{
	VLayout::layout_marked_window();
	doing_layout = false;
}

bool idle_task()
{
	if ( ! doing_layout && VLayout::need_layout() ) {
		doing_layout = true;
		vq_insert_callback(NULL,do_layout,0,0,0);
	}
	if(ms_loop_1())
		return true;
	return false;
}

void new_v_loop()
{
	static int debug=0;
	int idle_cnt = 0;
	UINT timer_id = 0;
	v_loop_tid = get_tid();
	
	MSG msg;
	while(TRUE){
		int b;
		if (timer_id) {
			GetMessage(&msg, NULL, 0, 0);
			b=1;
		} else
			b = PeekMessage(&msg, NULL, 0, 0, PM_REMOVE);
		current_time = msg.time;
		if(timer_id){
			KillTimer(NULL, timer_id);
			timer_id = 0;
		 }
		if(b){
			if(timer_id && msg.message == WM_TIMER && msg.wParam == timer_id)
				continue;
			idle_cnt = 0;
			if(msg.message == WM_QUIT)
				break;
			if(msg.message >= WM_MOUSEFIRST && msg.message <= WM_MOUSELAST)
				VTrackedInfo::track_mouse(&msg);
			if ( translate_accel(&msg) )
				continue;
			HWND dlg = get_active_dialog();
			if ( dlg && IsDialogMessage(dlg, &msg) )
				continue;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else{
			if ( idle_task() )
				idle_cnt = 0;
			else if (++idle_cnt>=10)
				timer_id = SetTimer(NULL, 0, 10, NULL);
		}
	}
}

void v_loop(){
	//create_task(ms_loop, 0, PRI_USER_INTERFACE);
	new_v_loop();
}

} // extern "C"