/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "machine/include.h"

#include "v/VClipboard.h"
#include "v/v_serialized_exec.h"
extern "C" {
#include "memory_debug.h"
}

void * VClipboard::data = 0;
int VClipboard::data_type = 0;

static bool _is_data_type_available(int type)
{
	OpenClipboard(NULL);
	bool ret = IsClipboardFormatAvailable(type);
	CloseClipboard();
	return ret;
}

bool
VClipboard::is_data_type_available(int type)
{
	return v_serialized_exec_func(_is_data_type_available, type);
}


static void _set_data_type(int type, int len, void *data, bool clear)
{
	OpenClipboard(NULL);
	if ( clear )
		EmptyClipboard();
	HGLOBAL hg = GlobalAlloc(GHND | GMEM_SHARE , len);
	void *ds = GlobalLock(hg);
	memcpy(ds, data, len);
	GlobalUnlock(hg);
	SetClipboardData(type, hg);
	CloseClipboard();
}

void
VClipboard::set_data_type(int type, int len, void *data, bool clear)
{
	v_serialized_exec_sub(_set_data_type, type, len, data, clear);
}


static void * _get_data_type(int type, int *outLen, void **data)
{
	HGLOBAL hg;
	if ( ! OpenClipboard(NULL) || ! (hg = GetClipboardData(type))) {
		*data = 0;
		*outLen = 0;
		return 0;
	}
	*data = hg;
	*outLen = GlobalSize(hg);
	return GlobalLock(hg);
}

void *
VClipboard::get_data_type(int type, int &outLen)
{
	return v_serialized_exec_func(_get_data_type, type, &outLen, &data);
}


static void _release_data(void *data)
{
	if ( data == 0 )
		return;
	HGLOBAL hg = (void**)data;
	GlobalUnlock(hg);
	CloseClipboard();
}

void
VClipboard::release_data()
{
	v_serialized_exec_sub(_release_data, data);
}



static void *
_convert_to_system_image_data(VImage* img, int *outSize)
{
/*
	HBITMAP hbitmap = ;
	short w = pict->picFrame.right - pict->picFrame.left;
	short h = pict->picFrame.bottom - pict->picFrame.top;
	Rect r = {0, 0, h, w};

	VImage *ret = v_image_new(w,h,32);
	v_image_draw_start(ret,0);
	ret->info->BeginDrawing();
	DrawPicture(&pict,&r);
	ret->info->EndDrawing();
	v_image_draw_end(ret);
	return ret;
*/
	return 0;
}

void *
VClipboard::convert_to_system_image_data(VImage* img, int *outSize)
{
	return v_serialized_exec_func(_convert_to_system_image_data, img, outSize);
}


static VImage *
_convert_from_system_image_data(void* img, int size, void** data)
{

	return 0;
}

VImage*
VClipboard::convert_from_system_image_data(void* img, int size)
{
	return v_serialized_exec_func(_convert_from_system_image_data, img, size, &data);
}


static void
_release_system_image_data(void** data)
{
}

void
VClipboard::release_system_image_data()
{
	v_serialized_exec_sub(_release_system_image_data, &data);
}

