/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "task.h"


/* Initialize semaphore object SEM to VALUE.  If PSHARED then share it
   with other processes.  */
/*
		sem_init initializes the semaphore object  pointed  to  by
		sem.   The count associated with the semaphore is set ini-
		tially to value.  The pshared argument  indicates  whether
		the semaphore is local to the current process ( pshared is
		zero) or is to  be  shared  between  several  processes  (
		pshared is not zero). LinuxThreads currently does not sup-
		port  process-shared  semaphores,  thus  sem_init   always
		returns with error ENOSYS if pshared is not zero.
*/
int sem_init(sem_t * sem, int pshared, unsigned int value)
{
	/* pshared ͌݊̂߂ɎcĂ܂Aۂɂ͎gpĂ܂B */

	sem->handle = CreateSemaphore(NULL, value, 1000, NULL);

	return 0;	/* gĂȂ悤Ȃ̂ŁAƂ肠0ԂĂ܂B */
}


/* Wait for SEM being posted.  */
/*
		sem_wait  suspends  the calling thread until the semaphore
		pointed to by sem has non-zero count. It  then  atomically
		decreases the semaphore count.
*/
int sem_wait(sem_t * sem)
{
	WaitForSingleObject(sem->handle, INFINITE);

	return 0;	/* gĂȂ悤Ȃ̂ŁAƂ肠0ԂĂ܂B */
}


/* Test whether SEM is posted.  */
/*
		sem_trywait is a non-blocking variant of sem_wait.  If the
		semaphore pointed to by sem has non-zero count, the  count
		is   atomically   decreased  and  sem_trywait  immediately
		returns 0.  If the semaphore count  is  zero,  sem_trywait
		immediately returns with error EAGAIN.
*/
int sem_trywait(sem_t * sem)
{
	return WaitForSingleObject(sem->handle, 0) == WAIT_OBJECT_0 ? 0 : EAGAIN;
}


/* Post SEM.  */
/*
		sem_post  atomically  increases the count of the semaphore
		pointed to by sem.  This function  never  blocks  and  can
		safely be used in asynchronous signal handlers.
*/
int sem_post(sem_t * sem)
{
	ReleaseSemaphore(sem->handle, 1, &(sem->sem_count));

	return 0;	/* gĂȂ悤Ȃ̂ŁAƂ肠0ԂĂ܂B */
}


/* Get current value of SEM and store it in *SVAL.  */
/*
		sem_getvalue stores in the location pointed to by sval the
		current count of the semaphore sem.
*/
#if 0	/* gĂȂ悤Ȃ̂... */
int sem_getvalue(sem_t * sem, int * sval) {	return 0; }
#endif


/* Free resources associated with semaphore object SEM.  */
/*
		sem_destroy  destroys  a  semaphore  object,  freeing  the
		resources  it  might hold. No threads should be waiting on
		the semaphore at the time sem_destroy is  called.  In  the
		LinuxThreads  implementation,  no resources are associated
		with semaphore objects,  thus  sem_destroy  actually  does
		nothing  except  checking that no thread is waiting on the
		semaphore.
*/
int sem_destroy(sem_t * sem)
{
	CloseHandle(sem->handle);

	return 0;	/* gĂȂ悤Ȃ̂ŁAƂ肠0ԂĂ܂B */
}

