/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"v.h"

typedef struct check_ev {
	VWINDOW * win;
	int	type;
	int	subtype;
	int	ret;
} CHECK_EV;

Bool
_predicate(Display * d,XEvent * ev,CHECK_EV * ch)
{
	if ( ch->win->d->d != d )
		return False;
	if ( ch->win != _get_vwin(ch->win->d,ev->xany.window) )
		return False;
	switch ( ev->xany.type ) {
	case Expose:
		if ( ch->type != VE_REDRAW )
			return False;
		break;
	case ButtonPress:
		if ( ch->type != VE_BUTTON )
			return False;
		if ( ch->subtype != VES_BUTTON_PRESS )
			return False;
		break;
	case ButtonRelease:
		if ( ch->type != VE_BUTTON )
			return False;
		if ( ch->subtype != VES_BUTTON_RELEASE )
			return False;
		break;
	case MotionNotify:
		if ( ch->type != VE_BUTTON )
			return False;
		if ( ch->subtype != VES_BUTTON_MOTION )
			return False;
		break;
	default:
		return False;
	}
	ch->ret = 1;
	return False;
}


typedef struct check_event_s {
	int		ret;
	VWINDOW *	win;
	int		type;
	int		subtype;
} CHECK_EVENT_S;

int
_check_event(CHECK_EVENT_S * v)
{
int ret;
XEvent ev;
CHECK_EV ch;

	ch.win = v->win;
	ch.type = v->type;
	ch.subtype = v->subtype;
	ch.ret = 0;
	XCheckIfEvent(
		v->win->d->d,
		&ev,
		_predicate,
		(char*)&ch);
	v->ret = ch.ret;
	return 0;
}


int
check_event(VWINDOW * win,int type,int subtype)
{
CHECK_EVENT_S v;
	v.win = win;
	v.type = type;
	v.subtype = subtype;
	v.ret = 0;
	ms_do(_check_event,&v,"check_event");
	return v.ret;
}