/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"utils.h"
#include	"xl.h"
#include	"memory_debug.h"

XL_SEXP * xl_Directory();

void
init_Directory(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Directory"),
		get_func_prim(xl_Directory,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_Directory(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * path;
L_CHAR * buf;
XL_SEXP * ret;
int len;
	path = get_el(s,1);
	switch ( get_type(path) ) {
	case XLT_ERROR:
		return path;
	case XLT_STRING:
		buf = ll_copy_str(path->string.data);
		break;
	default:
		goto type_missmatch;
	}
	len = l_strlen(buf)-1;
	for ( ; len >= 0 ; len -- )
		if ( buf[len] == '/' ) {
			buf[len+1] = 0;
			break;
		}
	if ( len < 0 )
		ret = get_string(l_string(std_cm,"."));
	else	ret = get_string(buf);
	d_f_ree(buf);
	return ret;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Trunk"),
		0);
}
