/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"utils.h"
#include	"task.h"
#include	"pri_level.h"


void (*memory_watchdog_func)();
int memory_watchdog_count;

void
_memory_watchdog()
{
INTEGER64 s,d;
void (*func)();
	for ( ; ; ) {
		func = memory_watchdog_func;
		if ( func ) {
			s = get_mem_size();
			d = get_usedmemory_size();
			if ( s <= d || 512*1024*1024 <= d )
				(*func)();
		}
		sleep_sec(20);
	}
}


void
_memory_watchdog_tick()
{
	for ( ; memory_watchdog_count < 2 ; ) {
		memory_watchdog_count ++;
		create_task(_memory_watchdog,0,PRI_TICK_CLOSE);
	}
}

void
memory_watchdog(void (*func)())
{
	memory_watchdog_func = func;
	new_tick(_memory_watchdog_tick,0,0);
}

