/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___ASSOCIATE64_H___
#define ___ASSOCIATE64_H___

#include	"pdb64.h"

#define FAT_ASSOC_INTEGER	0x100
#define FAT_ASSOC_STRING	0x102

#define ASSOC_KEY_NO		10

typedef struct acc_pn_assoc_header64 {
	ACC_HEADER64		a;
	PN_ASSOC_HEADER64		d;
} ACC_PN_ASSOC_HEADER64;

typedef struct acc_pn_assoc_data64 {
	ACC_HEADER64		a;
	PN_ASSOC_DATA64		d;
} ACC_PN_ASSOC_DATA64;


typedef struct acc_pn_file_header64 {
	ACC_HEADER64		a;
	PN_FILE_HEADER64		d;
} ACC_PN_FILE_HEADER64;

typedef struct assoc_key64 {
	PDB64 *			p;
	ACC_PN_FILE_HEADER64 *	fheader;
	ACC_PN_ASSOC_HEADER64 *	assoc;
	int			assoc_len;
} ASSOC_KEY64;

typedef struct assoc_integer64 {
	int			data;
	unsigned int		fofs;
} ASSOC_INTEGER64;

typedef struct assoc_string_opt64 {
	int			flags;
	int			size;
} ASSOC_STRING_OPT64;

int
open_associate64(
	char * filename,
	int oflags,
	int mode,
	int flags,
	int type,
	char * encoding);
int insert_associate64(int key,int index,void * from,XL_SEXP * data);
XL_SEXP * search_associate64(int key,int index,void * from,void * opt);
int get_index64(int key,short name);
int new_index64(int key,short type,short name);
int get_index_type64(int key,int index);
XL_SEXP * get_assoc_all64(int key,int index);

#endif

