/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"gbview.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"win_flame.h"

XL_SEXP * xl_gv_flame_click();
XL_SEXP * gvstatus2list(GBVIEW_STATUS * gs);
XL_SEXP * gbp2list(GBVIEW_PLANE * gbp, XL_SYM_FIELD * sf);



void
init_gv_flame_click(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"gv-flame-click"),
		get_func_prim(xl_gv_flame_click,FO_APPLICATIVE,0,3,3));
}


XL_SEXP * xl_gv_flame_click(
	XLISP_ENV * e,
	XL_SEXP * s,
	XLISP_ENV * a_e,
	XL_SYM_FIELD * sf)
{
XL_SEXP * gbp_list, *gs_list;
XL_SEXP *x,*y;
GBVIEW_STATUS sts;
GBVIEW_PLANE gbp;
int seq;
GBVIEW_FLAME * gf;

	gf = get_gf_from_sf(sf);

	x = get_el(s,1);
	y = get_el(s,2);
	if ( get_type(x) != XLT_INTEGER || get_type(y) != XLT_INTEGER )
		goto type_mismatch;

	seq = wf_click(gf,&sts, &gbp,x->integer.data,y->integer.data);

	gs_list = gvstatus2list(&sts);
	wf_free_status(&sts);

	if ( seq == 0 ) {
		return List(get_integer(0,0),gs_list,-1);
	}

	gbp_list = gbp2list(&gbp,sf);
	wf_free_plane(&gbp);
	if ( gbp_list == 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"gv-flame-click"),
			List(n_get_string("unknown format"),
			-1));		
	else
		return List(get_integer(seq,0),gs_list,gbp_list,-1);

type_mismatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gv-flame-click"),
		List(n_get_string("type missmatch"),
			-1));
}
