/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"gbgraph.h"


GB_POINT3D mp_mul3d(REAL1 m[3][3],GB_POINT3D p)
{
GB_POINT3D ret;
	ret.x = m[0][0]*p.x + m[0][1]*p.y + m[0][2]*p.z;
	ret.y = m[1][0]*p.x + m[1][1]*p.y + m[1][2]*p.z;
	ret.z = m[2][0]*p.x + m[2][1]*p.y + m[2][2]*p.z;
	return ret;
}


void
m_mul3d(MATRIX3D ret,MATRIX3D a,MATRIX3D b)
{
int i,j,k;
double acc;
	for ( i = 0 ;  i < 3 ; i ++ )
		for ( j = 0; j < 3 ; j ++ ) {
			acc = 0;
			for ( k = 0 ; k < 3 ; k ++ )
				acc += a[i][k] * b[k][j];
			ret[i][j] = acc;
		}
}